/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.ast.ClassElement;

public enum JavaPrimitiveElement implements ClassElement,
AnnotationMetadataDelegate
{
    INT("int"),
    CHAR("char"),
    BOOLEAN("boolean"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("double"),
    SHORT("short"),
    BYTE("byte"),
    INT_ARRAY("int", true),
    CHAR_ARRAY("char", true),
    BOOLEAN_ARRAY("boolean", true),
    LONG_ARRAY("long", true),
    FLOAT_ARRAY("float", true),
    DOUBLE_ARRAY("double", true),
    SHORT_ARRAY("short", true),
    BYTE_ARRAY("byte", true);

    private final String typeName;
    private final boolean isArray;

    private JavaPrimitiveElement(String typeName) {
        this.typeName = typeName;
        this.isArray = false;
    }

    private JavaPrimitiveElement(String typeName, boolean array) {
        this.typeName = typeName;
        this.isArray = array;
    }

    public boolean isAssignable(String type) {
        return false;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String getName() {
        return this.typeName;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPublic() {
        return true;
    }

    public Object getNativeType() {
        return ClassUtils.forName((String)this.typeName, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    JavaPrimitiveElement toArray() {
        if (this.isArray()) {
            throw new IllegalStateException("Already an array");
        }
        return JavaPrimitiveElement.valueOf(this.name() + "_ARRAY");
    }
}

