/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationProcessingOutputVisitor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class JavaVisitorContext
extends MutableConvertibleValuesMap<Object>
implements VisitorContext {
    private final Messager messager;
    private final Elements elements;
    private final AnnotationUtils annotationUtils;
    private final Types types;
    private final ModelUtils modelUtils;
    private final AnnotationProcessingOutputVisitor outputVisitor;

    public JavaVisitorContext(Messager messager, Elements elements, AnnotationUtils annotationUtils, Types types, ModelUtils modelUtils, Filer filer) {
        this.messager = messager;
        this.elements = elements;
        this.annotationUtils = annotationUtils;
        this.types = types;
        this.modelUtils = modelUtils;
        this.outputVisitor = new AnnotationProcessingOutputVisitor(filer);
    }

    public Optional<ClassElement> getClassElement(String name) {
        TypeElement typeElement = this.elements.getTypeElement(name);
        return Optional.ofNullable(typeElement).map(typeElement1 -> new JavaClassElement((TypeElement)typeElement1, this.annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)typeElement1), this, Collections.emptyList()));
    }

    public void info(String message, Element element) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            javax.lang.model.element.Element el = (javax.lang.model.element.Element)element.getNativeType();
            this.messager.printMessage(Diagnostic.Kind.NOTE, message, el);
        }
    }

    public void info(String message) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    public void fail(String message, Element element) {
        javax.lang.model.element.Element el = (javax.lang.model.element.Element)element.getNativeType();
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, el);
    }

    public void warn(String message, Element element) {
        javax.lang.model.element.Element el = (javax.lang.model.element.Element)element.getNativeType();
        this.messager.printMessage(Diagnostic.Kind.WARNING, message, el);
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path) {
        return this.outputVisitor.visitMetaInfFile(path);
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return this.outputVisitor.visitGeneratedFile(path);
    }

    public Messager getMessager() {
        return this.messager;
    }

    public ModelUtils getModelUtils() {
        return this.modelUtils;
    }

    public Elements getElements() {
        return this.elements;
    }

    public AnnotationUtils getAnnotationUtils() {
        return this.annotationUtils;
    }

    public Types getTypes() {
        return this.types;
    }
}

