/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.GenericUtils;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaConstructorElement;
import io.micronaut.annotation.processing.visitor.JavaEnumElement;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Internal
public class LoadedVisitor {
    private final TypeElementVisitor visitor;
    private final String classAnnotation;
    private final String elementAnnotation;
    private final JavaVisitorContext visitorContext;

    public LoadedVisitor(TypeElementVisitor visitor, JavaVisitorContext visitorContext, GenericUtils genericUtils, ProcessingEnvironment processingEnvironment) {
        this.visitorContext = visitorContext;
        this.visitor = visitor;
        Class<?> aClass = visitor.getClass();
        TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement(aClass.getName());
        if (typeElement != null) {
            List<? extends TypeMirror> generics = genericUtils.interfaceGenericTypesFor(typeElement, TypeElementVisitor.class.getName());
            this.classAnnotation = generics.get(0).toString();
            this.elementAnnotation = generics.get(1).toString();
        } else {
            Class[] classes = GenericTypeUtils.resolveInterfaceTypeArguments(aClass, TypeElementVisitor.class);
            if (classes != null && classes.length == 2) {
                this.classAnnotation = classes[0].getName();
                this.elementAnnotation = classes[1].getName();
            } else {
                this.classAnnotation = Object.class.getName();
                this.elementAnnotation = Object.class.getName();
            }
        }
    }

    public TypeElementVisitor getVisitor() {
        return this.visitor;
    }

    public boolean matches(TypeElement typeElement) {
        if (this.classAnnotation.equals("java.lang.Object")) {
            return true;
        }
        AnnotationMetadata annotationMetadata = this.visitorContext.getAnnotationUtils().getAnnotationMetadata(typeElement);
        return annotationMetadata.hasStereotype(this.classAnnotation);
    }

    public boolean matches(AnnotationMetadata annotationMetadata) {
        if (this.elementAnnotation.equals("java.lang.Object")) {
            return true;
        }
        return annotationMetadata.hasStereotype(this.elementAnnotation);
    }

    public void visit(Element element, AnnotationMetadata annotationMetadata) {
        if (element instanceof VariableElement) {
            this.visitor.visitField((FieldElement)new JavaFieldElement((VariableElement)element, annotationMetadata), (VisitorContext)this.visitorContext);
        } else if (element instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getSimpleName().toString().equals("<init>")) {
                this.visitor.visitConstructor((ConstructorElement)new JavaConstructorElement(executableElement, annotationMetadata, this.visitorContext), (VisitorContext)this.visitorContext);
            } else {
                this.visitor.visitMethod((MethodElement)new JavaMethodElement(executableElement, annotationMetadata, this.visitorContext), (VisitorContext)this.visitorContext);
            }
        } else if (element instanceof TypeElement) {
            boolean isEnum;
            TypeElement typeElement = (TypeElement)element;
            boolean bl = isEnum = typeElement.getKind() == ElementKind.ENUM;
            if (isEnum) {
                this.visitor.visitClass((ClassElement)new JavaEnumElement(typeElement, annotationMetadata, this.visitorContext, Collections.emptyList()), (VisitorContext)this.visitorContext);
            } else {
                this.visitor.visitClass((ClassElement)new JavaClassElement(typeElement, annotationMetadata, this.visitorContext), (VisitorContext)this.visitorContext);
            }
        }
    }

    public String toString() {
        return this.visitor.toString();
    }
}

