/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.jaxrs.common.JaxRsArgumentUtil;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.InterceptorContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
abstract class AbstractJaxRsInterceptorContext
implements InterceptorContext {
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final Argument<?> argument;
    private MediaType mediaType;
    private Class<?> type;
    private Type genericType;
    private Annotation[] annotations;

    protected AbstractJaxRsInterceptorContext(Argument<?> argument, MediaType mediaType) {
        this.argument = argument;
        this.mediaType = mediaType;
    }

    public final <T> Argument<T> asArgument() {
        AnnotationMetadata annotationMetadata;
        if (this.type == null && this.genericType == null && this.annotations == null) {
            return this.argument;
        }
        AnnotationMetadata annotationMetadata2 = annotationMetadata = this.annotations == null ? this.argument.getAnnotationMetadata() : JaxRsArgumentUtil.createAnnotationMetadata(this.annotations);
        if (this.genericType != null) {
            Argument genericArgument = Argument.of((Type)this.genericType);
            return Argument.of((Class)genericArgument.getType(), (AnnotationMetadata)annotationMetadata, (Argument[])genericArgument.getTypeParameters());
        }
        if (this.type != null) {
            return Argument.of(this.type, (AnnotationMetadata)annotationMetadata, (Argument[])new Argument[0]);
        }
        return Argument.of((Class)this.argument.getType(), (AnnotationMetadata)annotationMetadata, (Argument[])this.argument.getTypeParameters());
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public void setProperty(String name, Object object) {
        this.properties.put(name, object);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            return this.argument.getAnnotationMetadata().synthesizeAll();
        }
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        Objects.requireNonNull(annotations);
        this.annotations = annotations;
    }

    public Class<?> getType() {
        if (this.type == null) {
            return this.argument.getType();
        }
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Type getGenericType() {
        if (this.genericType == null) {
            return this.argument.asType();
        }
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }
}

