/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsMutableHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsReaderInterceptorContext;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

@Internal
public final class InterceptedMessageBodyReader<T>
implements MessageBodyReader<T> {
    @Nullable
    private final Class<?> readerType;
    private final MessageBodyReader<T> reader;
    private final List<ReaderInterceptor> readerInterceptor;

    public InterceptedMessageBodyReader(@Nullable Class<?> readerType, MessageBodyReader<T> reader, List<ReaderInterceptor> readerInterceptor) {
        this.readerType = readerType;
        this.reader = reader;
        this.readerInterceptor = readerInterceptor;
    }

    public boolean isReadable(@NonNull Argument<T> type, @Nullable io.micronaut.http.MediaType mediaType) {
        return (this.readerType == null || type.getType().isAssignableFrom(this.readerType)) && this.reader.isReadable(type, mediaType);
    }

    @Nullable
    public T read(@NonNull Argument<T> type, @Nullable io.micronaut.http.MediaType mediaType, @NonNull Headers httpHeaders, @NonNull InputStream inputStream) throws CodecException {
        try {
            Iterator<ReaderInterceptor> iterator = this.readerInterceptor.iterator();
            if (iterator.hasNext()) {
                JaxRsReaderInterceptorContext context = new JaxRsReaderInterceptorContext(iterator, ctx -> {
                    MediaType mediaType1 = ctx.getMediaType();
                    return this.reader.read(ctx.asArgument(), JaxRsUtils.convert(mediaType1), httpHeaders, ctx.getInputStream());
                }, type, JaxRsUtils.convert(mediaType), new JaxRsMutableHeadersMultivaluedMap((MutableHeaders)httpHeaders), inputStream);
                return (T)iterator.next().aroundReadFrom((ReaderInterceptorContext)context);
            }
            return (T)this.reader.read(type, mediaType, httpHeaders, inputStream);
        }
        catch (IOException e) {
            throw new CodecException("Failed to read", (Throwable)e);
        }
    }
}

