/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsMutableObjectHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.common.JaxRsWriterInterceptorContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

@Internal
public final class InterceptedMessageBodyWriter<T>
implements MessageBodyWriter<T> {
    @Nullable
    private final Class<?> writerType;
    private final MessageBodyWriter<T> delegate;
    private final List<WriterInterceptor> writerInterceptor;

    public InterceptedMessageBodyWriter(@Nullable Class<?> writerType, MessageBodyWriter<T> delegate, List<WriterInterceptor> writerInterceptor) {
        this.writerType = writerType;
        this.delegate = delegate;
        this.writerInterceptor = writerInterceptor;
    }

    public boolean isWriteable(@NonNull Argument<T> type, @Nullable io.micronaut.http.MediaType mediaType) {
        return (this.writerType == null || this.writerType.isAssignableFrom(type.getType())) && this.delegate.isWriteable(type, mediaType);
    }

    public void writeTo(@NonNull Argument<T> type, @NonNull io.micronaut.http.MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        try {
            Iterator<WriterInterceptor> iterator = this.writerInterceptor.iterator();
            JaxRsMutableObjectHeadersMultivaluedMap httpHeaders = new JaxRsMutableObjectHeadersMultivaluedMap(outgoingHeaders);
            if (iterator.hasNext()) {
                JaxRsWriterInterceptorContext context = new JaxRsWriterInterceptorContext(iterator, ctx -> {
                    MediaType mediaType1 = ctx.getMediaType();
                    this.delegate.writeTo(ctx.asArgument(), JaxRsUtils.convert(mediaType1), ctx.getEntity(), outgoingHeaders, ctx.getOutputStream());
                }, type, JaxRsUtils.convert(mediaType), httpHeaders, object, outputStream);
                iterator.next().aroundWriteTo((WriterInterceptorContext)context);
                return;
            }
            this.delegate.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
        }
        catch (IOException e) {
            throw new CodecException("Cannot write to", (Throwable)e);
        }
    }
}

