/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.context.AnnotationReflectionUtils;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;

@Internal
public final class JaxRsArgumentUtil {
    private JaxRsArgumentUtil() {
    }

    public static <T> Argument<T> from(InvocationCallback<T> callback) {
        return AnnotationReflectionUtils.resolveGenericToArgument(callback.getClass(), InvocationCallback.class).getTypeParameters()[0];
    }

    public static <T> Argument<T> from(Entity<T> entityType) {
        Argument argument = Argument.of(entityType.getEntity().getClass());
        return Argument.of((Class)argument.getType(), (AnnotationMetadata)JaxRsArgumentUtil.createAnnotationMetadata(entityType.getAnnotations()), (Argument[])argument.getTypeParameters());
    }

    public static <T> Argument<T> from(GenericType<T> entityType, Annotation[] annotations) {
        AnnotationMetadata annotationMetadata = JaxRsArgumentUtil.createAnnotationMetadata(annotations);
        Argument argument = Argument.of((Type)entityType.getType());
        return Argument.of((Class)argument.getType(), (AnnotationMetadata)annotationMetadata, (Argument[])argument.getTypeParameters());
    }

    public static <T> Argument<T> from(GenericType<T> entityType) {
        return Argument.of((Type)entityType.getType());
    }

    public static <T> Argument<T> from(GenericEntity<T> genericEntity) {
        Argument argument = Argument.of((Type)genericEntity.getType());
        return Argument.of((Class)argument.getType(), (AnnotationMetadata)AnnotationMetadata.EMPTY_METADATA, (Argument[])argument.getTypeParameters());
    }

    public static <T> Argument<T> from(GenericEntity<T> genericEntity, Annotation[] annotations) {
        AnnotationMetadata annotationMetadata = JaxRsArgumentUtil.createAnnotationMetadata(annotations);
        Argument argument = Argument.of((Type)genericEntity.getType());
        return Argument.of((Class)argument.getType(), (AnnotationMetadata)annotationMetadata, (Argument[])argument.getTypeParameters());
    }

    public static <T> Argument<T> from(Class<T> entityType, Annotation[] annotations) {
        return Argument.of(entityType, (AnnotationMetadata)JaxRsArgumentUtil.createAnnotationMetadata(annotations), (Argument[])new Argument[0]);
    }

    public static AnnotationMetadata createAnnotationMetadata(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() == null) continue;
            annotationMetadata.addAnnotation(annotation.annotationType().getName(), Map.of());
        }
        return annotationMetadata;
    }
}

