/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsArgumentUtil;
import io.micronaut.jaxrs.common.JaxRsGenericEntity;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.GenericEntity;
import java.io.OutputStream;
import java.util.List;

@Internal
@Singleton
final class JaxRsGenericEntityMessageBodyWriter<T>
implements MessageBodyWriter<GenericEntity<T>> {
    private final MessageBodyHandlerRegistry registry;

    JaxRsGenericEntityMessageBodyWriter(MessageBodyHandlerRegistry registry) {
        this.registry = registry;
    }

    public void writeTo(@NonNull Argument<GenericEntity<T>> type, @NonNull MediaType mediaType, GenericEntity<T> genericEntity, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        Argument<T> argument;
        if (genericEntity instanceof JaxRsGenericEntity) {
            JaxRsGenericEntity jaxRsGenericEntity = (JaxRsGenericEntity)genericEntity;
            argument = jaxRsGenericEntity.asArgument();
        } else {
            argument = JaxRsArgumentUtil.from(genericEntity);
        }
        Object entity = genericEntity.getEntity();
        this.registry.getWriter(argument, List.of(mediaType)).writeTo(argument, mediaType, entity, outgoingHeaders, outputStream);
    }
}

