/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsMutableObjectHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.common.JaxRsWriterInterceptorContext;
import io.micronaut.jaxrs.common.RouteReturnTypeProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Internal
@Singleton
@EachBean(value=MessageBodyWriter.class)
public final class JaxRsMessageBodyWriter<T>
implements io.micronaut.http.body.MessageBodyWriter<T> {
    private final List<MediaType> produces;
    private final MessageBodyWriter<T> delegate;
    private final List<WriterInterceptor> writerInterceptors;
    @Nullable
    private final RouteReturnTypeProvider routeReturnTypeProvider;

    @Inject
    public JaxRsMessageBodyWriter(BeanRegistration<MessageBodyWriter<T>> beanRegistration, List<WriterInterceptor> writerInterceptors, @Nullable RouteReturnTypeProvider routeReturnTypeProvider) {
        this((AnnotationMetadata)beanRegistration.getBeanDefinition(), (MessageBodyWriter)beanRegistration.bean(), writerInterceptors, routeReturnTypeProvider);
    }

    public JaxRsMessageBodyWriter(AnnotationMetadata annotationMetadata, MessageBodyWriter<T> delegate, List<WriterInterceptor> writerInterceptors, @Nullable RouteReturnTypeProvider routeReturnTypeProvider) {
        this.produces = JaxRsMessageBodyWriter.asMediaTypes(annotationMetadata);
        this.delegate = delegate;
        this.writerInterceptors = writerInterceptors;
        this.routeReturnTypeProvider = routeReturnTypeProvider;
        JaxRsUtils.sortByPriority(writerInterceptors);
    }

    public JaxRsMessageBodyWriter(Argument<?> writerArgument, MessageBodyWriter<T> delegate, List<WriterInterceptor> writerInterceptors) {
        this(writerArgument.getAnnotationMetadata(), delegate, writerInterceptors, null);
    }

    private static List<MediaType> asMediaTypes(AnnotationMetadata annotationMetadata) {
        AnnotationValue producesAnnotationValue = annotationMetadata.getAnnotation(Produces.class);
        if (producesAnnotationValue == null) {
            return List.of();
        }
        return Arrays.stream(producesAnnotationValue.stringValues()).map(MediaType::of).toList();
    }

    public boolean isWriteable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return this.delegate.isWriteable(type.getType(), type.asType(), type.getAnnotationMetadata().synthesizeAll(), JaxRsUtils.convert(mediaType));
    }

    public void writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        try {
            Argument<?> argument;
            if (type.getAnnotationMetadata().isEmpty() && this.routeReturnTypeProvider != null && (argument = this.routeReturnTypeProvider.provideReturnType()) != null && !argument.getAnnotationMetadata().isEmpty()) {
                type = Argument.of((Class)type.getType(), (AnnotationMetadata)argument.getAnnotationMetadata(), (Argument[])type.getTypeParameters());
            }
            Iterator<WriterInterceptor> iterator = this.writerInterceptors.iterator();
            JaxRsMutableObjectHeadersMultivaluedMap httpHeaders = new JaxRsMutableObjectHeadersMultivaluedMap(outgoingHeaders);
            if (iterator.hasNext()) {
                JaxRsWriterInterceptorContext context = new JaxRsWriterInterceptorContext(iterator, ctx -> this.delegate.writeTo(ctx.getEntity(), ctx.getType(), ctx.getGenericType(), ctx.getAnnotations(), ctx.getMediaType(), (MultivaluedMap)httpHeaders, ctx.getOutputStream()), type, JaxRsUtils.convert(mediaType), httpHeaders, object, outputStream);
                iterator.next().aroundWriteTo((WriterInterceptorContext)context);
                return;
            }
            if ((mediaType == null || JaxRsUtils.convert(mediaType).isWildcardType()) && this.produces.size() == 1) {
                httpHeaders.add("Content-Type", (Object)this.produces.get(0).toString());
            }
            this.delegate.writeTo(object, type.getType(), type.asType(), type.getAnnotationMetadata().synthesizeAll(), JaxRsUtils.convert(mediaType), (MultivaluedMap)httpHeaders, outputStream);
        }
        catch (IOException e) {
            throw new CodecException("Cannot write to", (Throwable)e);
        }
    }
}

