/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.UriBuilderException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@Internal
public class JaxRsUriBuilder
extends jakarta.ws.rs.core.UriBuilder {
    private final UriBuilder uriBuilder;

    public JaxRsUriBuilder() {
        this(UriBuilder.of((CharSequence)"/"));
    }

    JaxRsUriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
    }

    public jakarta.ws.rs.core.UriBuilder clone() {
        return new JaxRsUriBuilder(UriBuilder.of((URI)this.uriBuilder.build()));
    }

    public jakarta.ws.rs.core.UriBuilder uri(URI uri) {
        JaxRsUtils.requireNonNull("uri", uri);
        this.uriBuilder.replacePath(uri.getPath());
        this.uriBuilder.scheme(uri.getScheme());
        this.uriBuilder.port(uri.getPort());
        this.uriBuilder.fragment(uri.getFragment());
        this.uriBuilder.userInfo(uri.getUserInfo());
        this.uriBuilder.host(uri.getHost());
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder uri(String uriTemplate) {
        JaxRsUtils.requireNonNull("uriTemplate", uriTemplate);
        return this.uri(URI.create(uriTemplate));
    }

    public jakarta.ws.rs.core.UriBuilder scheme(String scheme) {
        this.uriBuilder.scheme(scheme);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder schemeSpecificPart(String ssp) {
        throw new UnsupportedOperationException("Method schemeSpecificPart(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder userInfo(String ui) {
        this.uriBuilder.userInfo(ui);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder host(String host) {
        this.uriBuilder.host(host);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder port(int port) {
        this.uriBuilder.port(port);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder replacePath(String path) {
        this.uriBuilder.replacePath(path == null ? "" : path);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder path(String path) {
        JaxRsUtils.requireNonNull("path", path);
        this.uriBuilder.path(path);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder path(Class resource) {
        JaxRsUtils.requireNonNull("resource", resource);
        Path annotation = resource.getAnnotation(Path.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Resource not annotated with @Path");
        }
        this.path(annotation.value());
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder path(Class resource, String method) {
        JaxRsUtils.requireNonNull("resource", resource);
        JaxRsUtils.requireNonNull("method", method);
        List<Method> candidates = Stream.of(resource.getMethods()).filter(m -> m.getName().equals(method) && m.isAnnotationPresent(Path.class)).toList();
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("No such method or not annotated with @Path");
        }
        if (candidates.size() > 1) {
            throw new IllegalArgumentException("Multiple method candidates");
        }
        return this.path(candidates.get(0));
    }

    public jakarta.ws.rs.core.UriBuilder path(Method method) {
        JaxRsUtils.requireNonNull("method", method);
        Path annotation = method.getAnnotation(Path.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Resource not annotated with @Path");
        }
        this.path(annotation.value());
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder segment(String ... segments) {
        JaxRsUtils.requireNonNull("segments", segments);
        for (String segment : segments) {
            JaxRsUtils.requireNonNull("segment[*]", segment);
        }
        return this.path(String.join((CharSequence)"/", segments));
    }

    public jakarta.ws.rs.core.UriBuilder replaceMatrix(String matrix) {
        throw new UnsupportedOperationException("Method replaceMatrix(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder matrixParam(String name, Object ... values) {
        throw new UnsupportedOperationException("Method matrixParam(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder replaceMatrixParam(String name, Object ... values) {
        throw new UnsupportedOperationException("Method replaceMatrixParam(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder replaceQuery(String query) {
        throw new UnsupportedOperationException("Method replaceQuery(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder queryParam(String name, Object ... values) {
        JaxRsUtils.requireNonNull("name", name);
        for (Object value : values) {
            JaxRsUtils.requireNonNull("values[*]", value);
        }
        this.uriBuilder.queryParam(name, values);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder replaceQueryParam(String name, Object ... values) {
        if (values == null) {
            throw new UnsupportedOperationException("Removing query params not supported");
        }
        this.uriBuilder.replaceQueryParam(name, values);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder fragment(String fragment) {
        this.uriBuilder.fragment(fragment);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplate(String name, Object value) {
        throw new UnsupportedOperationException("Method resolveTemplate(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplate(String name, Object value, boolean encodeSlashInPath) {
        throw new UnsupportedOperationException("Method resolveTemplate(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplateFromEncoded(String name, Object value) {
        throw new UnsupportedOperationException("Method resolveTemplateFromEncoded(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplates(Map<String, Object> templateValues) {
        throw new UnsupportedOperationException("Method resolveTemplates(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Method resolveTemplates(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplatesFromEncoded(Map<String, Object> templateValues) {
        throw new UnsupportedOperationException("Method resolveTemplateFromEncoded(..) not supported by implementation");
    }

    public URI buildFromMap(Map<String, ?> values) {
        return this.buildFromMap(values, true);
    }

    public URI buildFromMap(Map<String, ?> values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        for (Object v : values.values()) {
            JaxRsUtils.requireNonNull("values[*]", v);
        }
        return this.uriBuilder.expand(values);
    }

    public URI buildFromEncodedMap(Map<String, ?> values) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.expand(values);
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.build();
    }

    public URI build(Object[] values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.build();
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.build();
    }

    public String toTemplate() {
        return this.uriBuilder.toString();
    }
}

