/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.jaxrs.common.AbstractJaxRsInterceptorContext;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

@Internal
final class JaxRsWriterInterceptorContext
extends AbstractJaxRsInterceptorContext
implements WriterInterceptorContext {
    private final Iterator<WriterInterceptor> interceptors;
    private final IOProceedCallback interceptedSupplier;
    private final MultivaluedMap<String, Object> headers;
    private Object entity;
    private OutputStream outputStream;

    JaxRsWriterInterceptorContext(Iterator<WriterInterceptor> interceptors, IOProceedCallback interceptedCallback, Argument<?> argument, MediaType mediaType, MultivaluedMap<String, Object> headers, Object entity, OutputStream outputStream) {
        super(argument, mediaType);
        this.interceptors = interceptors;
        this.interceptedSupplier = interceptedCallback;
        this.headers = headers;
        this.entity = entity;
        this.outputStream = outputStream;
    }

    public void proceed() throws IOException, WebApplicationException {
        if (this.interceptors.hasNext()) {
            this.interceptors.next().aroundWriteTo((WriterInterceptorContext)this);
        } else {
            this.interceptedSupplier.call(this);
        }
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    @FunctionalInterface
    static interface IOProceedCallback {
        public void call(JaxRsWriterInterceptorContext var1) throws IOException;
    }
}

