/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.common.ParameterParser;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.Arrays;
import java.util.Map;

@Internal
final class MediaTypeHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<Object> {
    public static final String INVALID_MEDIA_TYPE = "Invalid media type: ";
    private static final Map<String, MediaType> MAP = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(200L).build();
    private static final Map<MediaType, String> REVERSE_MAP = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(200L).build();
    private static final char[] QUOTED_CHARS = "()<>@,;:\\\"/[]?= \t\r\n".toCharArray();

    MediaTypeHeaderDelegate() {
    }

    private static MediaType parse(String type) {
        MediaType result = MAP.get(type);
        if (result == null) {
            result = MediaTypeHeaderDelegate.internalParse(type);
            MAP.put(type, result);
            REVERSE_MAP.put(result, type);
        }
        return result;
    }

    static boolean quoted(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            for (char q : QUOTED_CHARS) {
                if (c != q) continue;
                return true;
            }
        }
        return false;
    }

    private static MediaType internalParse(String type) {
        String subtype;
        String major;
        int typeIndex = type.indexOf(47);
        int paramIndex = type.indexOf(59);
        if (typeIndex < 0) {
            major = type;
            if (paramIndex > -1) {
                major = major.substring(0, paramIndex);
            }
            if (!"*".equals(major)) {
                throw new IllegalArgumentException(INVALID_MEDIA_TYPE + type);
            }
            subtype = "*";
        } else {
            major = type.substring(0, typeIndex);
            subtype = paramIndex > -1 ? type.substring(typeIndex + 1, paramIndex) : type.substring(typeIndex + 1);
        }
        if (major.length() < 1 || subtype.length() < 1) {
            throw new IllegalArgumentException(INVALID_MEDIA_TYPE + type);
        }
        if (!MediaTypeHeaderDelegate.isValid(major) || !MediaTypeHeaderDelegate.isValid(subtype)) {
            throw new IllegalArgumentException(INVALID_MEDIA_TYPE + type);
        }
        String params = null;
        if (paramIndex > -1) {
            params = type.substring(paramIndex + 1);
        }
        if (params != null && !params.equals("")) {
            Map<String, String> typeParams = new ParameterParser().parse(params, ';');
            return new MediaType(major, subtype, typeParams);
        }
        return new MediaType(major, subtype);
    }

    private static boolean isValid(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char[] notValid = new char[]{'/', '\\', '?', ':', '<', '>', ';', '(', ')', '@', ',', '[', ']', '='};
        return str.chars().noneMatch(c -> Arrays.binarySearch(notValid, (char)c) >= 0);
    }

    public Object fromString(String type) throws IllegalArgumentException {
        JaxRsUtils.requireNonNull("type", type);
        return MediaTypeHeaderDelegate.parse(type);
    }

    public String toString(Object o) {
        JaxRsUtils.requireNonNull("o", o);
        MediaType type = (MediaType)o;
        String result = REVERSE_MAP.get(type);
        if (result == null) {
            result = this.internalToString(type);
            REVERSE_MAP.put(type, result);
            MAP.put(result, type);
        }
        return result;
    }

    private String internalToString(MediaType type) {
        StringBuilder buf = new StringBuilder();
        buf.append(type.getType().toLowerCase()).append("/").append(type.getSubtype().toLowerCase());
        if (type.getParameters() == null || type.getParameters().size() == 0) {
            return buf.toString();
        }
        for (String name : type.getParameters().keySet()) {
            buf.append(';').append(name).append('=');
            String val = (String)type.getParameters().get(name);
            if (MediaTypeHeaderDelegate.quoted(val)) {
                buf.append('\"').append(val).append('\"');
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }
}

