/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.jaxrs.common.CacheControlDelegate;
import io.micronaut.jaxrs.common.CookieHeaderDelegate;
import io.micronaut.jaxrs.common.EntityTagDelegate;
import io.micronaut.jaxrs.common.JaxRsResponseBuilder;
import io.micronaut.jaxrs.common.JaxRsUriBuilder;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.common.LinkBuilderImpl;
import io.micronaut.jaxrs.common.LinkDelegate;
import io.micronaut.jaxrs.common.MediaTypeHeaderDelegate;
import io.micronaut.jaxrs.common.NewCookieHeaderDelegate;
import io.micronaut.jaxrs.common.ObjectToStringDelegate;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;

@Internal
public final class MicronautRuntimeDelegate
extends RuntimeDelegate {
    private static final Map<Class<?>, RuntimeDelegate.HeaderDelegate<?>> HEADER_DELEGATES = new HashMap();

    public UriBuilder createUriBuilder() {
        return new JaxRsUriBuilder();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new JaxRsResponseBuilder();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        throw new UnsupportedOperationException("Method createVariantListBuilder() not supported by implementation");
    }

    public <T> T createEndpoint(Application application, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Method createEndpoint(..) not supported by implementation");
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) throws IllegalArgumentException {
        JaxRsUtils.requireNonNull("type", type);
        return HEADER_DELEGATES.getOrDefault(type, ObjectToStringDelegate.INSTANCE);
    }

    public Link.Builder createLinkBuilder() {
        return new LinkBuilderImpl();
    }

    public SeBootstrap.Configuration.Builder createConfigurationBuilder() {
        return SeBootstrap.Configuration.builder();
    }

    public CompletionStage<SeBootstrap.Instance> bootstrap(Application application, SeBootstrap.Configuration configuration) {
        return SeBootstrap.start((Application)application, (SeBootstrap.Configuration)configuration);
    }

    public CompletionStage<SeBootstrap.Instance> bootstrap(Class<? extends Application> clazz, SeBootstrap.Configuration configuration) {
        return SeBootstrap.start(clazz, (SeBootstrap.Configuration)configuration);
    }

    public EntityPart.Builder createEntityPartBuilder(@NonNull String partName) throws IllegalArgumentException {
        return EntityPart.withName((String)partName);
    }

    static {
        HEADER_DELEGATES.put(MediaType.class, new MediaTypeHeaderDelegate());
        HEADER_DELEGATES.put(Cookie.class, new CookieHeaderDelegate());
        HEADER_DELEGATES.put(EntityTag.class, new EntityTagDelegate());
        HEADER_DELEGATES.put(NewCookie.class, new NewCookieHeaderDelegate());
        HEADER_DELEGATES.put(Link.class, new LinkDelegate());
        HEADER_DELEGATES.put(CacheControl.class, CacheControlDelegate.INSTANCE);
        HEADER_DELEGATES.put(Object.class, ObjectToStringDelegate.INSTANCE);
    }
}

