/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

final class ServerCookie
implements Serializable {
    private static final String TSPECIALS = ",; ";
    private static final String TSPECIALS_2 = "()<>@,;:\\\"/[]?={} \t";
    private static final Locale LOCALE_US = Locale.US;
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final DateFormat OLD_COOKIE_FORMAT = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", LOCALE_US);
    private static final String ANCIENT_DATE = ServerCookie.formatOldCookie(new Date(10000L));

    ServerCookie() {
    }

    private static boolean isToken(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (TSPECIALS.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private static boolean containsCTL(String value) {
        if (value == null) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' || c == '\t') continue;
            return true;
        }
        return false;
    }

    private static boolean isToken2(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (TSPECIALS_2.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static String getCookieHeaderName(int version) {
        if (version == 1) {
            return "Set-Cookie";
        }
        return "Set-Cookie";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatOldCookie(Date d) {
        String ocf;
        DateFormat dateFormat = OLD_COOKIE_FORMAT;
        synchronized (dateFormat) {
            ocf = OLD_COOKIE_FORMAT.format(d);
        }
        return ocf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatOldCookie(Date d, StringBuffer sb, FieldPosition fp) {
        DateFormat dateFormat = OLD_COOKIE_FORMAT;
        synchronized (dateFormat) {
            OLD_COOKIE_FORMAT.format(d, sb, fp);
        }
    }

    static void appendCookieValue(StringBuilder headerBuf, int version, String name, String value, String path, String domain, String comment, int maxAge, boolean isSecure) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append("=");
        ServerCookie.maybeQuote2(version, buf, value);
        if (version == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                ServerCookie.maybeQuote2(version, buf, comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            ServerCookie.maybeQuote2(version, buf, domain);
        }
        if (maxAge >= 0) {
            if (version == 0) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ANCIENT_DATE);
                } else {
                    ServerCookie.formatOldCookie(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            } else {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
        }
        if (path != null) {
            buf.append("; Path=");
            ServerCookie.maybeQuote2(version, buf, path);
        }
        if (isSecure) {
            buf.append("; Secure");
        }
        headerBuf.append(buf);
    }

    private static boolean alreadyQuoted(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    private static void maybeQuote2(int version, StringBuffer buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else {
            if (ServerCookie.containsCTL(value)) {
                throw new IllegalArgumentException("Invalid control character in cookie value: " + value);
            }
            if (ServerCookie.alreadyQuoted(value)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 1, value.length() - 1));
                buf.append('\"');
            } else if (version == 0 && !ServerCookie.isToken(value)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else if (version == 1 && !ServerCookie.isToken2(value)) {
                buf.append('\"');
                buf.append(ServerCookie.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else {
                buf.append(value);
            }
        }
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid character in cookie: " + s);
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }
}

