/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Internal
final class Encode {
    public static final Pattern URI_TEMPLATE_PATTERN;
    private static final Pattern NON_CODES;
    private static final String UTF_8;
    private static final Pattern PARAM_REPLACEMENT;
    private static final String[] PATH_ENCODING;
    private static final String[] PATH_SEGMENT_ENCODING;
    private static final String[] MATRIX_PARAMETER_ENCODING;
    private static final String[] QUERY_NAME_VALUE_ENCODING;
    private static final String[] QUERY_STRING_ENCODING;
    private static final char OPEN_CURLY_REPLACEMENT = '\u0006';
    private static final char CLOSE_CURLY_REPLACEMENT = '\u0007';

    Encode() {
    }

    public static String encodeQueryString(String value) {
        return Encode.encodeValue(value, QUERY_STRING_ENCODING);
    }

    public static String encodePath(String value) {
        return Encode.encodeValue(value, PATH_ENCODING);
    }

    public static String encodePathSegment(String value) {
        return Encode.encodeValue(value, PATH_SEGMENT_ENCODING);
    }

    public static String encodeFragment(String value) {
        return Encode.encodeValue(value, QUERY_STRING_ENCODING);
    }

    public static String encodeMatrixParam(String value) {
        return Encode.encodeValue(value, MATRIX_PARAMETER_ENCODING);
    }

    public static String encodeQueryParam(String value) {
        return Encode.encodeValue(value, QUERY_NAME_VALUE_ENCODING);
    }

    public static String encodeNonCodes(String string) {
        Matcher matcher = NON_CODES.matcher(string);
        StringBuilder builder = new StringBuilder();
        int idx = 0;
        while (matcher.find(idx)) {
            int start = matcher.start();
            builder.append(string, idx, start);
            builder.append("%25");
            idx = start + 1;
        }
        builder.append(string.substring(idx));
        return builder.toString();
    }

    public static boolean savePathParams(String segmentString, StringBuilder newSegment, List<String> params) {
        boolean foundParam = false;
        CharSequence segment = Encode.replaceEnclosedCurlyBracesCS(segmentString);
        Matcher matcher = URI_TEMPLATE_PATTERN.matcher(segment);
        int start = 0;
        while (matcher.find()) {
            newSegment.append(segment, start, matcher.start());
            foundParam = true;
            String group = matcher.group();
            params.add(Encode.recoverEnclosedCurlyBraces(group));
            newSegment.append("_resteasy_uri_parameter");
            start = matcher.end();
        }
        newSegment.append(segment, start, segment.length());
        return foundParam;
    }

    public static String encodeValue(String segment, String[] encoding) {
        ArrayList<String> params = new ArrayList<String>();
        boolean foundParam = false;
        StringBuilder newSegment = new StringBuilder();
        if (Encode.savePathParams(segment, newSegment, params)) {
            foundParam = true;
            segment = newSegment.toString();
        }
        String result = Encode.encodeFromArray(segment, encoding, false);
        segment = result = Encode.encodeNonCodes(result);
        if (foundParam) {
            segment = Encode.pathParamReplacement(segment, params);
        }
        return segment;
    }

    public static String encodePathAsIs(String segment) {
        return Encode.encodeFromArray(segment, PATH_ENCODING, true);
    }

    public static String encodePathSaveEncodings(String segment) {
        String result = Encode.encodeFromArray(segment, PATH_ENCODING, false);
        result = Encode.encodeNonCodes(result);
        return result;
    }

    public static String encodePathSegmentAsIs(String segment) {
        return Encode.encodeFromArray(segment, PATH_SEGMENT_ENCODING, true);
    }

    public static String encodePathSegmentSaveEncodings(String segment) {
        String result = Encode.encodeFromArray(segment, PATH_SEGMENT_ENCODING, false);
        result = Encode.encodeNonCodes(result);
        return result;
    }

    public static String encodeQueryParamAsIs(String nameOrValue) {
        return Encode.encodeFromArray(nameOrValue, QUERY_NAME_VALUE_ENCODING, true);
    }

    public static String encodeQueryParamSaveEncodings(String segment) {
        String result = Encode.encodeFromArray(segment, QUERY_NAME_VALUE_ENCODING, false);
        result = Encode.encodeNonCodes(result);
        return result;
    }

    private static String encodeFromArray(String segment, String[] encodingMap, boolean encodePercent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < segment.length(); ++i) {
            char currentChar = segment.charAt(i);
            if (!encodePercent && currentChar == '%') {
                result.append(currentChar);
                continue;
            }
            if (Character.isHighSurrogate(currentChar)) {
                String part = segment.substring(i, i + 2);
                result.append(URLEncoder.encode(part, StandardCharsets.UTF_8));
                ++i;
                continue;
            }
            String encoding = Encode.encode(currentChar, encodingMap);
            if (encoding == null) {
                result.append(currentChar);
                continue;
            }
            result.append(encoding);
        }
        return result.toString();
    }

    private static String encode(int zhar, String[] encodingMap) {
        String encoded = zhar < encodingMap.length ? encodingMap[zhar] : Encode.encodeString(Character.toString((char)zhar));
        return encoded;
    }

    public static String encodeString(String s) {
        try {
            return URLEncoder.encode(s, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String pathParamReplacement(String segment, List<String> params) {
        StringBuilder newSegment = new StringBuilder();
        Matcher matcher = PARAM_REPLACEMENT.matcher(segment);
        int i = 0;
        int start = 0;
        while (matcher.find()) {
            newSegment.append(segment, start, matcher.start());
            String replacement = params.get(i++);
            newSegment.append(replacement);
            start = matcher.end();
        }
        newSegment.append(segment, start, segment.length());
        segment = newSegment.toString();
        return segment;
    }

    public static CharSequence replaceEnclosedCurlyBracesCS(String str) {
        int open = 0;
        CharSequence cs = str;
        char[] chars = null;
        for (int i = 0; i < str.length(); ++i) {
            if (cs.charAt(i) == '{') {
                if (open != 0) {
                    if (cs == str) {
                        chars = str.toCharArray();
                        cs = new ArrayCharSequence(chars);
                    }
                    chars[i] = 6;
                }
                ++open;
                continue;
            }
            if (cs.charAt(i) != '}' || --open == 0) continue;
            if (cs == str) {
                chars = str.toCharArray();
                cs = new ArrayCharSequence(chars);
            }
            chars[i] = 7;
        }
        return cs;
    }

    public static String recoverEnclosedCurlyBraces(String str) {
        return str.replace('\u0006', '{').replace('\u0007', '}');
    }

    static {
        int i;
        URI_TEMPLATE_PATTERN = Pattern.compile("(\\{([^}]+)})");
        NON_CODES = Pattern.compile("%([^a-fA-F0-9]|[a-fA-F0-9]$|$|[a-fA-F0-9][^a-fA-F0-9])");
        UTF_8 = StandardCharsets.UTF_8.name();
        PARAM_REPLACEMENT = Pattern.compile("_resteasy_uri_parameter");
        PATH_ENCODING = new String[128];
        PATH_SEGMENT_ENCODING = new String[128];
        MATRIX_PARAMETER_ENCODING = new String[128];
        QUERY_NAME_VALUE_ENCODING = new String[128];
        QUERY_STRING_ENCODING = new String[128];
        block12: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case '_': 
                case '~': {
                    continue block12;
                }
                default: {
                    Encode.PATH_ENCODING[i] = Encode.encodeString(String.valueOf((char)i));
                }
            }
        }
        Encode.PATH_ENCODING[32] = "%20";
        System.arraycopy(PATH_ENCODING, 0, MATRIX_PARAMETER_ENCODING, 0, PATH_ENCODING.length);
        Encode.MATRIX_PARAMETER_ENCODING[59] = "%3B";
        Encode.MATRIX_PARAMETER_ENCODING[61] = "%3D";
        Encode.MATRIX_PARAMETER_ENCODING[47] = "%2F";
        System.arraycopy(PATH_ENCODING, 0, PATH_SEGMENT_ENCODING, 0, PATH_ENCODING.length);
        Encode.PATH_SEGMENT_ENCODING[47] = "%2F";
        block13: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '-': 
                case '.': 
                case '_': 
                case '~': {
                    continue block13;
                }
                case '?': {
                    Encode.QUERY_NAME_VALUE_ENCODING[i] = "%3F";
                    continue block13;
                }
                case ' ': {
                    Encode.QUERY_NAME_VALUE_ENCODING[i] = "+";
                    continue block13;
                }
                default: {
                    Encode.QUERY_NAME_VALUE_ENCODING[i] = Encode.encodeString(String.valueOf((char)i));
                }
            }
        }
        block14: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '_': 
                case '~': {
                    continue block14;
                }
                case ' ': {
                    Encode.QUERY_STRING_ENCODING[i] = "%20";
                    continue block14;
                }
                default: {
                    Encode.QUERY_STRING_ENCODING[i] = Encode.encodeString(String.valueOf((char)i));
                }
            }
        }
    }

    private static final class ArrayCharSequence
    implements CharSequence {
        private final char[] buf;
        private final int offset;
        private final int count;

        public ArrayCharSequence(char[] buff) {
            this(buff, 0, buff.length);
        }

        public ArrayCharSequence(char[] buff, int offset, int count) {
            this.buf = buff;
            this.offset = offset;
            this.count = count;
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.count) {
                throw new StringIndexOutOfBoundsException(index);
            }
            return this.buf[this.offset + index];
        }

        @Override
        public int length() {
            return this.count;
        }

        @Override
        public CharSequence subSequence(int beginIndex, int endIndex) {
            if (beginIndex < 0) {
                throw new StringIndexOutOfBoundsException(beginIndex);
            }
            if (endIndex > this.count) {
                throw new StringIndexOutOfBoundsException(endIndex);
            }
            if (beginIndex > endIndex) {
                throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
            }
            return beginIndex == 0 && endIndex == this.count ? this : new ArrayCharSequence(this.buf, this.offset + beginIndex, endIndex - beginIndex);
        }

        @Override
        public String toString() {
            return new String(this.buf, this.offset, this.count);
        }
    }
}

