/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Headers;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.jaxrs.common.CookieHeaderDelegate;
import io.micronaut.jaxrs.common.JaxRsHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.Weighted;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public class JaxRsHttpHeaders
implements HttpHeaders {
    private final io.micronaut.http.HttpHeaders httpHeaders;
    private final boolean isResponse;

    JaxRsHttpHeaders(io.micronaut.http.HttpHeaders httpHeaders, boolean isResponse) {
        this.httpHeaders = httpHeaders;
        this.isResponse = isResponse;
    }

    public static JaxRsHttpHeaders forRequest(io.micronaut.http.HttpHeaders httpHeaders) {
        return new JaxRsHttpHeaders(httpHeaders, false);
    }

    public static JaxRsHttpHeaders forResponse(io.micronaut.http.HttpHeaders httpHeaders) {
        return new JaxRsHttpHeaders(httpHeaders, true);
    }

    public List<String> getRequestHeader(String name) {
        return this.httpHeaders.getAll((CharSequence)name);
    }

    public String getHeaderString(String name) {
        List all = this.httpHeaders.getAll((CharSequence)name);
        if (all.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", all);
    }

    public final boolean containsHeaderString(String name, String valueSeparatorRegex, Predicate<String> valuePredicate) {
        return this.httpHeaders.getAll((CharSequence)name).stream().flatMap(value -> Arrays.stream(value.split(valueSeparatorRegex))).map(String::trim).anyMatch(valuePredicate);
    }

    public final boolean containsHeaderString(String name, Predicate<String> valuePredicate) {
        return this.containsHeaderString(name, ",", valuePredicate);
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return new JaxRsHeadersMultivaluedMap((Headers)this.httpHeaders);
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.httpHeaders.getAll((CharSequence)"Accept").stream().flatMap(text -> {
            int len = text.length();
            if (len == 0) {
                return Stream.of(MediaType.valueOf((String)"*/*"));
            }
            if (text.indexOf(44) > -1) {
                return Arrays.stream(text.split(",")).map(str -> {
                    int i = str.indexOf(59);
                    MediaType mt = MediaType.valueOf((String)str);
                    if (i > -1) {
                        return new Weighted<MediaType>(mt, mt.getParameters());
                    }
                    return new Weighted<MediaType>(mt);
                }).sorted().map(Weighted::getObject).toList().stream();
            }
            return Stream.of(MediaType.valueOf((String)text));
        }).toList();
    }

    public List<Locale> getAcceptableLanguages() {
        return this.httpHeaders.getAll((CharSequence)"Accept-Language").stream().flatMap(text -> {
            int len = text.length();
            if (len == 0 || len == 1 && text.charAt(0) == '*') {
                return Stream.of(new Locale[0]);
            }
            if (text.indexOf(44) > -1) {
                return Arrays.stream(text.split(",")).map(str -> {
                    int i = str.indexOf(59);
                    if (i > -1) {
                        String tag = str.substring(0, i).trim();
                        Map<String, String> params = Weighted.parseParameters(str);
                        return new Weighted<Locale>(Locale.forLanguageTag(tag), params);
                    }
                    return new Weighted<Locale>(Locale.forLanguageTag(str.trim()));
                }).sorted().map(Weighted::getObject).toList().stream();
            }
            return Stream.of(Locale.forLanguageTag(text));
        }).toList();
    }

    public MediaType getMediaType() {
        return this.httpHeaders.getContentType().map(MediaType::valueOf).orElse(null);
    }

    public Locale getLanguage() {
        return this.httpHeaders.getFirst((CharSequence)"Content-Language").map(Locale::forLanguageTag).orElse(null);
    }

    public Map<String, Cookie> getCookies() {
        List cookieHeaders = this.httpHeaders.getAll((CharSequence)(this.isResponse ? "Set-Cookie" : "Cookie"));
        LinkedHashMap cookies = CollectionUtils.newLinkedHashMap((int)cookieHeaders.size());
        for (String cookieHeader : cookieHeaders) {
            List<Cookie> parsed = CookieHeaderDelegate.parseCookies(cookieHeader);
            for (Cookie cookie : parsed) {
                cookies.put(cookie.getName(), cookie);
            }
        }
        return Collections.unmodifiableMap(cookies);
    }

    public Date getDate() {
        ZonedDateTime date = this.httpHeaders.getDate((CharSequence)"Date");
        if (date != null) {
            return Date.from(date.toInstant());
        }
        return null;
    }

    public int getLength() {
        if (this.httpHeaders.contains("Content-Length")) {
            return this.httpHeaders.getInt((CharSequence)"Content-Length");
        }
        return -1;
    }
}

