/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsReaderInterceptorContext;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

@Internal
@Singleton
@EachBean(value=jakarta.ws.rs.ext.MessageBodyReader.class, remapGenerics={@EachBean.RemapGeneric(name="T", type=MessageBodyReader.class)})
public final class JaxRsMessageBodyReader<T>
implements MessageBodyReader<T> {
    private final jakarta.ws.rs.ext.MessageBodyReader<T> delegate;
    private final List<ReaderInterceptor> readerInterceptor;

    public JaxRsMessageBodyReader(jakarta.ws.rs.ext.MessageBodyReader<T> delegate, List<ReaderInterceptor> readerInterceptor) {
        this.delegate = delegate;
        this.readerInterceptor = readerInterceptor;
        JaxRsUtils.sortByPriority(readerInterceptor);
    }

    public jakarta.ws.rs.ext.MessageBodyReader<T> getDelegate() {
        return this.delegate;
    }

    public boolean isReadable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return this.delegate.isReadable(type.getType(), type.asType(), type.getAnnotationMetadata().synthesizeAll(), JaxRsUtils.convert(mediaType));
    }

    @Nullable
    public T read(@NonNull Argument<T> type, @Nullable MediaType mediaType, @NonNull Headers httpHeaders, @NonNull InputStream inputStream) throws CodecException {
        try {
            Iterator<ReaderInterceptor> iterator = this.readerInterceptor.iterator();
            if (iterator.hasNext()) {
                JaxRsReaderInterceptorContext context = new JaxRsReaderInterceptorContext(iterator, ctx -> this.delegate.readFrom(ctx.getType(), ctx.getGenericType(), ctx.getAnnotations(), ctx.getMediaType(), (MultivaluedMap)new JaxRsHeadersMultivaluedMap(httpHeaders), ctx.getInputStream()), type, JaxRsUtils.convert(mediaType), new JaxRsHeadersMultivaluedMap(httpHeaders), inputStream);
                return (T)iterator.next().aroundReadFrom((ReaderInterceptorContext)context);
            }
            return (T)this.delegate.readFrom(type.getType(), type.asType(), type.getAnnotationMetadata().synthesizeAll(), JaxRsUtils.convert(mediaType), (MultivaluedMap)new JaxRsHeadersMultivaluedMap(httpHeaders), inputStream);
        }
        catch (IOException e) {
            throw new CodecException("Failed to read", (Throwable)e);
        }
    }
}

