/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.jaxrs.common.JaxRsObjectHeadersMultivaluedMap;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.List;
import java.util.Objects;

@Internal
@Singleton
public final class JaxRsMutableObjectHeadersMultivaluedMap
extends JaxRsObjectHeadersMultivaluedMap {
    private final MutableHeaders headers;

    public JaxRsMutableObjectHeadersMultivaluedMap(MutableHeaders headers) {
        super((Headers)headers);
        this.headers = headers;
    }

    @Override
    public void putSingle(String key, Object value) {
        this.remove(key);
        this.add(key, value);
    }

    @Override
    public void add(String key, Object value) {
        Objects.requireNonNull(value);
        RuntimeDelegate.HeaderDelegate headerDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(value.getClass());
        this.headers.add((CharSequence)key, (CharSequence)headerDelegate.toString(value));
    }

    @Override
    public List<Object> remove(Object key) {
        if (key instanceof String) {
            String s = (String)key;
            Object prev = this.get(key);
            this.headers.remove((CharSequence)s);
            return prev;
        }
        if (key == null) {
            return this.get(null);
        }
        return null;
    }

    @Override
    public List<Object> put(String key, List<Object> value) {
        Object prev = this.get(key);
        if (key != null) {
            this.headers.remove((CharSequence)key);
        }
        this.addAll(key, value);
        return prev.isEmpty() ? null : prev;
    }
}

