/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Headers;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.inject.Singleton;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Singleton
@Internal
public final class JaxRsReaderMessageBodyWriter
implements MessageBodyWriter<Reader> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Reader.class.isAssignableFrom(type);
    }

    public void writeTo(Reader reader, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Charset charset = io.micronaut.http.body.MessageBodyWriter.findCharset((io.micronaut.http.MediaType)JaxRsUtils.convert(mediaType), (Headers)new CaseInsensitiveMutableHttpHeaders(httpHeaders, ConversionService.SHARED)).orElse(StandardCharsets.UTF_8);
        try (OutputStreamWriter out = new OutputStreamWriter(entityStream, charset);){
            reader.transferTo(out);
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

