/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.HttpMessage;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseProvider;
import io.micronaut.jaxrs.common.HttpMessageEntityReader;
import io.micronaut.jaxrs.common.JaxRsArgumentUtil;
import io.micronaut.jaxrs.common.JaxRsHttpHeaders;
import io.micronaut.jaxrs.common.JaxRsObjectHeadersMultivaluedMap;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public class JaxRsResponse
extends Response
implements HttpResponseProvider {
    private final HttpResponse<?> response;
    private final HttpMessageEntityReader entityReader;
    private final JaxRsHttpHeaders jaxRsHttpHeaders;
    private boolean buffered;
    private boolean closed;
    private byte[] buffer;
    private Argument<?> readBodyArgument;
    private Object readBody;

    public JaxRsResponse(HttpResponse<?> response) {
        this(response, HttpMessageEntityReader.DEFAULT);
    }

    public JaxRsResponse(HttpResponse<?> response, HttpMessageEntityReader entityReader) {
        this.response = response;
        this.entityReader = entityReader;
        this.jaxRsHttpHeaders = JaxRsHttpHeaders.forResponse(response.getHeaders());
    }

    public JaxRsResponse withEntityReader(HttpMessageEntityReader entityReader) {
        return new JaxRsResponse(this.response, entityReader);
    }

    public HttpResponse<?> getResponse() {
        return this.response;
    }

    public int getStatus() {
        return this.response.code();
    }

    public Response.StatusType getStatusInfo() {
        return new Response.StatusType(){

            public int getStatusCode() {
                return JaxRsResponse.this.getStatus();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)this.getStatusCode());
            }

            public String getReasonPhrase() {
                String reason = JaxRsResponse.this.response.reason();
                if (JaxRsResponse.this.response.code() == 200 && reason.equals("Ok")) {
                    reason = "OK";
                }
                return reason;
            }
        };
    }

    public Object getEntity() {
        this.checkCanReadEntity();
        return this.response.body();
    }

    public <T> T readEntity(Argument<T> entityType) {
        if (this.readBodyArgument != null && this.readBodyArgument.getType().equals(entityType.getType())) {
            return (T)this.readBody;
        }
        this.checkCanReadEntity();
        try {
            if (this.buffered) {
                T t = this.entityReader.readEntity((HttpMessage<?>)this.response.toMutableResponse().body((Object)this.buffer), entityType);
                return t;
            }
            this.readBodyArgument = entityType;
            Object object = this.readBody = this.entityReader.readEntity((HttpMessage<?>)this.response, entityType);
            return (T)object;
        }
        finally {
            this.close();
        }
    }

    public <T> T readEntity(Class<T> entityType) {
        return this.readEntity(Argument.of(entityType));
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return this.readEntity(JaxRsArgumentUtil.from(entityType));
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        return this.readEntity(JaxRsArgumentUtil.from(entityType, annotations));
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return this.readEntity(JaxRsArgumentUtil.from(entityType, annotations));
    }

    public boolean hasEntity() {
        this.checkCanReadEntity();
        return this.response.getBody().isPresent();
    }

    private void checkCanReadEntity() {
        if (this.closed && !this.buffered) {
            throw new IllegalStateException("Response closed");
        }
    }

    public boolean bufferEntity() {
        if (!this.buffered) {
            this.checkCanReadEntity();
            Optional body = this.response.getBody(byte[].class);
            if (body.isEmpty()) {
                return false;
            }
            this.buffer = body.orElse(new byte[0]);
            this.buffered = true;
        }
        return this.buffered;
    }

    public void close() {
        this.closed = true;
    }

    public MediaType getMediaType() {
        return this.jaxRsHttpHeaders.getMediaType();
    }

    public Locale getLanguage() {
        return this.jaxRsHttpHeaders.getLanguage();
    }

    public int getLength() {
        return this.jaxRsHttpHeaders.getLength();
    }

    public Set<String> getAllowedMethods() {
        return this.response.getHeaders().getAll((CharSequence)"Allow").stream().map(String::toUpperCase).collect(Collectors.toUnmodifiableSet());
    }

    @Nullable
    public Map<String, NewCookie> getCookies() {
        RuntimeDelegate.HeaderDelegate newCookieHeaderDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(NewCookie.class);
        return this.response.getHeaders().getAll((CharSequence)"Set-Cookie").stream().map(arg_0 -> ((RuntimeDelegate.HeaderDelegate)newCookieHeaderDelegate).fromString(arg_0)).collect(Collectors.toUnmodifiableMap(Cookie::getName, c -> c));
    }

    public EntityTag getEntityTag() {
        return this.response.getHeaders().getFirst((CharSequence)"ETag").map(entityTag -> (EntityTag)RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).fromString(entityTag)).orElse(null);
    }

    public Date getDate() {
        return this.jaxRsHttpHeaders.getDate();
    }

    public Date getLastModified() {
        return this.response.getHeaders().getFirst((CharSequence)"Last-Modified", Date.class).orElse(null);
    }

    public URI getLocation() {
        return this.response.getHeaders().getFirst((CharSequence)"Location").map(URI::create).orElse(null);
    }

    public Set<Link> getLinks() {
        return this.response.getHeaders().getAll((CharSequence)"Link").stream().map(Link::valueOf).collect(Collectors.toSet());
    }

    public boolean hasLink(String relation) {
        return this.getLinks().stream().anyMatch(link -> link.getRel().equals(relation));
    }

    public Link getLink(String relation) {
        return this.getLinks().stream().filter(link -> link.getRel().equals(relation)).findFirst().orElse(null);
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.jaxRsHttpHeaders.getRequestHeaders();
    }

    public String getHeaderString(String name) {
        return this.jaxRsHttpHeaders.getHeaderString(name);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.getHeaders();
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return new JaxRsObjectHeadersMultivaluedMap((Headers)this.response.getHeaders());
    }
}

