/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;

@Prototype
@Internal
public final class JaxRsStreamingOutputMessageBodyWriter<T extends StreamingOutput>
implements MessageBodyWriter<T> {
    public boolean isWriteable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return StreamingOutput.class.isAssignableFrom(type.getType());
    }

    public void writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T streamingOutput, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        try {
            streamingOutput.write(outputStream);
        }
        catch (IOException e) {
            throw new CodecException("Cannot write", (Throwable)e);
        }
    }
}

