/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.jaxrs.common.Encode;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Internal
final class JaxRsUriBuilder
extends UriBuilder {
    private static final String URI_PARAM_NAME_REGEX = "\\w[\\w.-]*";
    private static final String URI_PARAM_REGEX_REGEX = "[^{}][^{}]*";
    private static final String URI_PARAM_REGEX = "\\{\\s*(\\w[\\w.-]*)\\s*(:\\s*([^{}][^{}]*))?}";
    private static final Pattern URI_PARAM_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w.-]*)\\s*(:\\s*([^{}][^{}]*))?}");
    private static final Pattern OPAQUE_URI = Pattern.compile("^([^:/?#{]+):([^/].*)");
    private static final Pattern HIERARCHICAL_URI = Pattern.compile("^(([^:/?#{]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern HOST_PORT_PATTERN = Pattern.compile("([^/:]+):(\\d+)");
    private static final Pattern SQUARE_HOST_BRACKETS = Pattern.compile("(\\[(([0-9A-Fa-f]{0,4}:){2,7})([0-9A-Fa-f]{0,4})%?.*]):(\\d+)");
    private static final String REPLACEMENT_URI_PARAMETER = "_jaxrs_uri_parameter";
    private static final Pattern PARAM_REPLACEMENT = Pattern.compile("_jaxrs_uri_parameter");
    private String host;
    private String scheme;
    private int port = -1;
    private String userInfo;
    private String path;
    private String query;
    private String fragment;
    private String ssp;
    private String authority;
    private boolean encode = true;
    private MultiQueryParamMode queryParamMode = MultiQueryParamMode.MULTI_PAIRS;

    JaxRsUriBuilder() {
    }

    public UriBuilder clone() {
        JaxRsUriBuilder impl = new JaxRsUriBuilder();
        impl.host = this.host;
        impl.scheme = this.scheme;
        impl.port = this.port;
        impl.userInfo = this.userInfo;
        impl.path = this.path;
        impl.query = this.query;
        impl.fragment = this.fragment;
        impl.ssp = this.ssp;
        impl.authority = this.authority;
        impl.queryParamMode = this.queryParamMode;
        impl.encode = this.encode;
        return impl;
    }

    public static boolean compare(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static URI relativize(URI from, URI to) {
        int i;
        if (!JaxRsUriBuilder.compare(from.getScheme(), to.getScheme())) {
            return to;
        }
        if (!JaxRsUriBuilder.compare(from.getHost(), to.getHost())) {
            return to;
        }
        if (from.getPort() != to.getPort()) {
            return to;
        }
        if (from.getPath() == null && to.getPath() == null) {
            return URI.create("");
        }
        if (from.getPath() == null) {
            return URI.create(to.getPath());
        }
        if (to.getPath() == null) {
            return to;
        }
        String fromPath = from.getPath();
        if (fromPath.startsWith("/")) {
            fromPath = fromPath.substring(1);
        }
        String[] fsplit = fromPath.split("/");
        String toPath = to.getPath();
        if (toPath.startsWith("/")) {
            toPath = toPath.substring(1);
        }
        String[] tsplit = toPath.split("/");
        for (int f = 0; f < fsplit.length && f < tsplit.length && fsplit[f].equals(tsplit[f]); ++f) {
        }
        UriBuilder builder = UriBuilder.fromPath((String)"");
        for (i = f; i < fsplit.length; ++i) {
            builder.path("..");
        }
        for (i = f; i < tsplit.length; ++i) {
            builder.path(tsplit[i]);
        }
        return builder.build(new Object[0]);
    }

    public static JaxRsUriBuilder fromTemplate(String uriTemplate) {
        JaxRsUriBuilder impl = (JaxRsUriBuilder)RuntimeDelegate.getInstance().createUriBuilder();
        impl.uriTemplate(uriTemplate);
        return impl;
    }

    public UriBuilder uriTemplate(CharSequence uriTemplate) {
        if (uriTemplate == null) {
            throw new IllegalArgumentException("URI template cannot be null");
        }
        Matcher opaque = OPAQUE_URI.matcher(uriTemplate);
        if (opaque.matches()) {
            this.authority = null;
            this.host = null;
            this.port = -1;
            this.userInfo = null;
            this.query = null;
            this.scheme = opaque.group(1);
            this.ssp = opaque.group(2);
            return this;
        }
        Matcher match = HIERARCHICAL_URI.matcher(uriTemplate);
        if (match.matches()) {
            this.ssp = null;
            return this.parseHierarchicalUri(uriTemplate, match);
        }
        throw new IllegalArgumentException("Illegal URI template" + uriTemplate);
    }

    private UriBuilder parseHierarchicalUri(CharSequence uriTemplate, Matcher match) {
        String authority;
        boolean scheme;
        boolean bl = scheme = match.group(2) != null;
        if (scheme) {
            this.scheme = match.group(2);
        }
        if ((authority = match.group(4)) != null) {
            Matcher bracketsMatch;
            Matcher hostPortMatch;
            this.authority = null;
            String host = match.group(4);
            int at = host.indexOf(64);
            if (at > -1) {
                String user = host.substring(0, at);
                host = host.substring(at + 1);
                this.userInfo = user;
            }
            if ((hostPortMatch = HOST_PORT_PATTERN.matcher(host)).matches()) {
                this.host = hostPortMatch.group(1);
                try {
                    this.port = Integer.parseInt(hostPortMatch.group(2));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal URI template" + uriTemplate, e);
                }
            }
            if (host.startsWith("[") && (bracketsMatch = SQUARE_HOST_BRACKETS.matcher(host)).matches()) {
                host = bracketsMatch.group(1);
                try {
                    this.port = Integer.parseInt(bracketsMatch.group(5));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal URI template" + uriTemplate, e);
                }
            }
            this.host = host;
        }
        if (match.group(5) != null) {
            String group = match.group(5);
            if (!(scheme || "".equals(group) || group.startsWith("/") || group.indexOf(58) <= -1 || group.indexOf(47) <= -1 || group.indexOf(58) >= group.indexOf(47))) {
                throw new IllegalArgumentException("Illegal URI template" + uriTemplate);
            }
            if (!"".equals(group)) {
                this.replacePath(group);
            }
        }
        if (match.group(7) != null) {
            this.replaceQuery(match.group(7));
        }
        if (match.group(9) != null) {
            this.fragment(match.group(9));
        }
        return this;
    }

    public UriBuilder uri(String uriTemplate) throws IllegalArgumentException {
        return this.uriTemplate(uriTemplate);
    }

    public UriBuilder uriFromCharSequence(CharSequence uriTemplate) throws IllegalArgumentException {
        return this.uriTemplate(uriTemplate);
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        if (uri.isOpaque()) {
            this.scheme = uri.getScheme();
            this.ssp = uri.getRawSchemeSpecificPart();
            return this;
        }
        if (uri.getScheme() == null) {
            if (this.ssp != null && uri.getRawSchemeSpecificPart() != null) {
                this.ssp = uri.getRawSchemeSpecificPart();
                return this;
            }
        } else {
            this.scheme = uri.getScheme();
        }
        this.ssp = null;
        if (uri.getRawAuthority() != null) {
            if (uri.getRawUserInfo() == null && uri.getHost() == null && uri.getPort() == -1) {
                this.authority = uri.getRawAuthority();
                this.userInfo = null;
                this.host = null;
                this.port = -1;
            } else {
                this.authority = null;
                if (uri.getRawUserInfo() != null) {
                    this.userInfo = uri.getRawUserInfo();
                }
                if (uri.getHost() != null) {
                    this.host = uri.getHost();
                }
                if (uri.getPort() != -1) {
                    this.port = uri.getPort();
                }
            }
        }
        if (uri.getRawPath() != null && !uri.getRawPath().isEmpty()) {
            this.path = uri.getRawPath();
        }
        if (uri.getRawQuery() != null && !uri.getRawQuery().isEmpty()) {
            this.query = uri.getRawQuery();
        }
        return this;
    }

    public UriBuilder scheme(String scheme) throws IllegalArgumentException {
        this.scheme = scheme;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        URI uri;
        if (ssp == null) {
            throw new IllegalArgumentException("ssp cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        sb.append(ssp);
        if (this.fragment != null && !this.fragment.isEmpty()) {
            sb.append('#').append(this.fragment);
        }
        if ((uri = URI.create(sb.toString())).getRawSchemeSpecificPart() != null && uri.getRawPath() == null) {
            this.ssp = uri.getRawSchemeSpecificPart();
        } else {
            this.ssp = null;
            this.userInfo = uri.getRawUserInfo();
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.path = uri.getRawPath();
            this.query = uri.getRawQuery();
        }
        return this;
    }

    public UriBuilder userInfo(String ui) {
        this.userInfo = ui;
        return this;
    }

    public UriBuilder host(String host) throws IllegalArgumentException {
        if (host != null && host.isEmpty()) {
            throw new IllegalArgumentException("invalid host");
        }
        this.host = host;
        return this;
    }

    public UriBuilder port(int port) throws IllegalArgumentException {
        if (port < -1) {
            throw new IllegalArgumentException("invalid port");
        }
        this.port = port;
        return this;
    }

    public UriBuilder encode(boolean encode) {
        this.encode = encode;
        return this;
    }

    private static String paths(boolean encode, String basePath, String ... segments) {
        StringBuilder path = new StringBuilder();
        if (basePath != null) {
            path.append(basePath);
        }
        for (String segment : segments) {
            if ("".equals(segment)) continue;
            if (!path.isEmpty() && path.charAt(path.length() - 1) == '/') {
                if (segment.startsWith("/") && (segment = segment.substring(1)).isEmpty()) continue;
                if (encode) {
                    segment = Encode.encodePath(segment);
                }
                path.append(segment);
                continue;
            }
            if (encode) {
                segment = Encode.encodePath(segment);
            }
            if (path.isEmpty()) {
                path.append(segment);
                continue;
            }
            if (segment.startsWith("/")) {
                path.append(segment);
                continue;
            }
            path.append("/").append(segment);
        }
        return path.toString();
    }

    public UriBuilder path(String segment) throws IllegalArgumentException {
        if (segment == null) {
            throw new IllegalArgumentException("segment was null");
        }
        this.path = JaxRsUriBuilder.paths(this.encode, this.path, segment);
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("resource was null");
        }
        Path ann = resource.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("class must be annotated with @Path");
        }
        String[] segments = new String[]{ann.value()};
        this.path = JaxRsUriBuilder.paths(true, this.path, segments);
        return this;
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        if (resource == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Method theMethod = null;
        for (Method m : resource.getMethods()) {
            if (!m.getName().equals(method)) continue;
            if (theMethod != null && m.isAnnotationPresent(Path.class)) {
                throw new IllegalArgumentException("Two methods with the same path " + method);
            }
            if (!m.isAnnotationPresent(Path.class)) continue;
            theMethod = m;
        }
        if (theMethod == null) {
            throw new IllegalArgumentException("No public method annotated with @Path " + resource.getName() + " " + method);
        }
        return this.path(theMethod);
    }

    public UriBuilder path(Method method) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path ann = method.getAnnotation(Path.class);
        if (ann == null) {
            throw new IllegalArgumentException("Method not annotated with @Path");
        }
        this.path = JaxRsUriBuilder.paths(this.encode, this.path, ann.value());
        return this;
    }

    public UriBuilder replaceMatrix(String matrix) throws IllegalArgumentException {
        if (matrix == null) {
            matrix = "";
        }
        if (!((String)matrix).startsWith(";")) {
            matrix = ";" + (String)matrix;
        }
        matrix = Encode.encodePath((String)matrix);
        if (this.path == null) {
            this.path = matrix;
        } else {
            int matrixIndex;
            int start = this.path.lastIndexOf(47);
            if (start < 0) {
                start = 0;
            }
            this.path = (matrixIndex = this.path.indexOf(59, start)) > -1 ? this.path.substring(0, matrixIndex) + (String)matrix : this.path + (String)matrix;
        }
        return this;
    }

    public UriBuilder replaceQuery(String query) throws IllegalArgumentException {
        if (query == null || query.isEmpty()) {
            this.query = null;
            return this;
        }
        this.query = Encode.encodeQueryString(query);
        return this;
    }

    public UriBuilder fragment(String fragment) throws IllegalArgumentException {
        if (fragment == null) {
            this.fragment = null;
            return this;
        }
        this.fragment = Encode.encodeFragment(fragment);
        return this;
    }

    public UriBuilder substitutePathParam(String name, Object value, boolean isEncoded) {
        if (this.path != null) {
            StringBuilder builder = new StringBuilder();
            this.replacePathParameter(name, value.toString(), isEncoded, this.path, builder, false);
            this.path = builder.toString();
        }
        return this;
    }

    public URI buildFromMap(Map<String, ?> values) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildUriFromMap(values, false, true);
    }

    public URI buildFromEncodedMap(Map<String, ?> values) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildUriFromMap(values, true, false);
    }

    public URI buildFromMap(Map<String, ?> values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildUriFromMap(values, false, encodeSlashInPath);
    }

    private URI buildUriFromMap(Map<String, ?> paramMap, boolean fromEncodedMap, boolean encodeSlash) throws IllegalArgumentException, UriBuilderException {
        String buf = this.buildString(paramMap, fromEncodedMap, false, encodeSlash);
        try {
            return URI.create(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create URI", e);
        }
    }

    private String buildString(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, boolean encodeSlash) {
        return this.buildCharSequence(paramMap, fromEncodedMap, isTemplate, encodeSlash).toString();
    }

    private CharSequence buildCharSequence(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, boolean encodeSlash) {
        StringBuilder builder = new StringBuilder();
        if (this.scheme != null) {
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.scheme, builder, encodeSlash).append(":");
        }
        if (this.ssp != null) {
            builder.append(this.ssp);
        } else if (this.userInfo != null || this.host != null || this.port != -1) {
            builder.append("//");
            if (this.userInfo != null) {
                this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.userInfo, builder, encodeSlash).append("@");
            }
            if (this.host != null) {
                if (this.host.isEmpty()) {
                    throw new UriBuilderException("empty host");
                }
                this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.host, builder, encodeSlash);
            }
            if (this.port != -1) {
                builder.append(":").append(this.port);
            }
        } else if (this.authority != null) {
            builder.append("//");
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.authority, builder, encodeSlash);
        }
        if (this.path != null) {
            StringBuilder tmp = new StringBuilder();
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.path, tmp, this.encode, encodeSlash);
            if (!(this.userInfo == null && this.host == null || tmp.isEmpty() || tmp.charAt(0) == '/')) {
                builder.append("/");
            }
            builder.append((CharSequence)tmp);
        }
        if (this.query != null) {
            builder.append("?");
            this.replaceQueryStringParameter(paramMap, fromEncodedMap, isTemplate, this.query, builder);
        }
        if (this.fragment != null) {
            builder.append("#");
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.fragment, builder, encodeSlash);
        }
        return builder;
    }

    private void replacePathParameter(String name, String value, boolean isEncoded, String string, StringBuilder builder, boolean encodeSlash) {
        if (string.indexOf(123) == -1) {
            builder.append(string);
            return;
        }
        Matcher matcher = JaxRsUriBuilder.createUriParamMatcher(string);
        int start = 0;
        while (matcher.find()) {
            String param = matcher.group(1);
            if (!param.equals(name)) continue;
            builder.append(string, start, matcher.start());
            value = !isEncoded ? (encodeSlash ? Encode.encodePath(value) : Encode.encodePathSegment(value)) : Encode.encodeNonCodes(value);
            builder.append(value);
            start = matcher.end();
        }
        builder.append(string, start, string.length());
    }

    public static Matcher createUriParamMatcher(String string) {
        return URI_PARAM_PATTERN.matcher(Encode.replaceEnclosedCurlyBracesCS(string));
    }

    private StringBuilder replaceParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuilder builder, boolean encodeSlash) {
        return this.replaceParameter(paramMap, fromEncodedMap, isTemplate, string, builder, true, encodeSlash);
    }

    private StringBuilder replaceParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuilder builder, boolean encode, boolean encodeSlash) {
        if (string.indexOf(123) == -1) {
            return builder.append(string);
        }
        Matcher matcher = JaxRsUriBuilder.createUriParamMatcher(string);
        int start = 0;
        while (matcher.find()) {
            String stringValue;
            builder.append(string, start, matcher.start());
            String param = matcher.group(1);
            boolean containsValueForParam = paramMap.containsKey(param);
            if (!containsValueForParam) {
                if (isTemplate) {
                    builder.append(matcher.group());
                    start = matcher.end();
                    continue;
                }
                throw new IllegalArgumentException("Path parameter not provided " + param);
            }
            Object value = paramMap.get(param);
            String string2 = stringValue = value != null ? value.toString() : null;
            if (stringValue == null) {
                throw new IllegalArgumentException("Template parameter null: " + param);
            }
            if (encode) {
                stringValue = !fromEncodedMap ? (encodeSlash ? Encode.encodePathSegmentAsIs(stringValue) : Encode.encodePathAsIs(stringValue)) : (encodeSlash ? Encode.encodePathSegmentSaveEncodings(stringValue) : Encode.encodePathSaveEncodings(stringValue));
            }
            builder.append(stringValue);
            start = matcher.end();
        }
        builder.append(string, start, string.length());
        return builder;
    }

    private void replaceQueryStringParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuilder builder) {
        if (string.indexOf(123) == -1) {
            builder.append(string);
            return;
        }
        Matcher matcher = JaxRsUriBuilder.createUriParamMatcher(string);
        int start = 0;
        while (matcher.find()) {
            String stringValue;
            builder.append(string, start, matcher.start());
            String param = matcher.group(1);
            boolean containsValueForParam = paramMap.containsKey(param);
            if (!containsValueForParam) {
                if (isTemplate) {
                    builder.append(matcher.group());
                    start = matcher.end();
                    continue;
                }
                throw new IllegalArgumentException("Path parameter not provided " + param);
            }
            Object value = paramMap.get(param);
            String string2 = stringValue = value != null ? value.toString() : null;
            if (stringValue != null) {
                stringValue = !fromEncodedMap ? Encode.encodeQueryParamAsIs(stringValue) : Encode.encodeQueryParamSaveEncodings(stringValue);
                builder.append(stringValue);
                start = matcher.end();
                continue;
            }
            throw new IllegalArgumentException("Template param was null: " + param);
        }
        builder.append(string, start, string.length());
    }

    public List<String> getPathParamNamesInDeclarationOrder() {
        ArrayList<String> params = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        if (this.scheme != null) {
            this.addToPathParamList(params, set, this.scheme);
        }
        if (this.userInfo != null) {
            this.addToPathParamList(params, set, this.userInfo);
        }
        if (this.host != null) {
            this.addToPathParamList(params, set, this.host);
        }
        if (this.path != null) {
            this.addToPathParamList(params, set, this.path);
        }
        if (this.query != null) {
            this.addToPathParamList(params, set, this.query);
        }
        if (this.fragment != null) {
            this.addToPathParamList(params, set, this.fragment);
        }
        return params;
    }

    private void addToPathParamList(List<String> params, HashSet<String> set, String string) {
        Matcher matcher = URI_PARAM_PATTERN.matcher(Encode.replaceEnclosedCurlyBracesCS(string));
        while (matcher.find()) {
            String param = matcher.group(1);
            if (set.contains(param)) continue;
            set.add(param);
            params.add(param);
        }
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildFromValues(true, false, values);
    }

    private URI buildFromValues(boolean encodeSlash, boolean encoded, Object ... values) {
        try {
            String buf = this.buildString(new URITemplateParametersMap(values), encoded, false, encodeSlash);
            return new URI(buf);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new UriBuilderException("failed to create URI", (Throwable)e);
        }
    }

    public UriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        this.checkForNullValues(values);
        if (this.path == null) {
            this.path = "";
        }
        for (Object val : values) {
            this.path = this.path + ";" + Encode.encodeMatrixParam(name) + "=" + Encode.encodeMatrixParam(val.toString());
        }
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        int matrixIndex;
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (this.path == null) {
            if (values != null && values.length > 0) {
                return this.matrixParam(name, values);
            }
            return this;
        }
        ArrayList<String> pathParams = new ArrayList<String>();
        boolean foundParam = false;
        CharSequence pathWithoutEnclosedCurlyBraces = Encode.replaceEnclosedCurlyBracesCS(this.path);
        Matcher matcher = Encode.URI_TEMPLATE_PATTERN.matcher(pathWithoutEnclosedCurlyBraces);
        StringBuilder newSegment = new StringBuilder();
        int from = 0;
        while (matcher.find()) {
            newSegment.append(pathWithoutEnclosedCurlyBraces, from, matcher.start());
            foundParam = true;
            String group = matcher.group();
            pathParams.add(Encode.recoverEnclosedCurlyBraces(group));
            newSegment.append(REPLACEMENT_URI_PARAMETER);
            from = matcher.end();
        }
        newSegment.append(pathWithoutEnclosedCurlyBraces, from, pathWithoutEnclosedCurlyBraces.length());
        this.path = newSegment.toString();
        int start = this.path.lastIndexOf(47);
        if (start < 0) {
            start = 0;
        }
        if ((matrixIndex = this.path.indexOf(59, start)) > -1) {
            String matrixParams = this.path.substring(matrixIndex + 1);
            this.path = this.path.substring(0, matrixIndex);
            InternalMultivaluedHashMap map = new InternalMultivaluedHashMap();
            String[] params = matrixParams.split(";");
            for (String param : params) {
                int idx = param.indexOf(61);
                if (idx < 0) {
                    map.add(param, null);
                    continue;
                }
                String theName = param.substring(0, idx);
                String value = "";
                if (idx + 1 < param.length()) {
                    value = param.substring(idx + 1);
                }
                map.add(theName, value);
            }
            map.remove(name);
            for (String theName : map.keySet()) {
                List vals = (List)map.get(theName);
                for (Object val : vals) {
                    if (val == null) {
                        this.path = this.path + ";" + theName;
                        continue;
                    }
                    this.path = this.path + ";" + theName + "=" + val;
                }
            }
        }
        if (values != null && values.length > 0) {
            this.matrixParam(name, values);
        }
        if (foundParam) {
            matcher = PARAM_REPLACEMENT.matcher(this.path);
            newSegment = new StringBuilder();
            int i = 0;
            from = 0;
            while (matcher.find()) {
                newSegment.append(this.path, from, matcher.start());
                newSegment.append((String)pathParams.get(i++));
                from = matcher.end();
            }
            newSegment.append(this.path, from, this.path.length());
            this.path = newSegment.toString();
        }
        return this;
    }

    public UriBuilder clientQueryParam(String name, Object ... values) throws IllegalArgumentException {
        String queryParamName;
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        if (this.query == null) {
            this.query = "";
        } else {
            sb.append(this.query).append("&");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        String string = queryParamName = this.encode ? Encode.encodeQueryParamAsIs(name) : name;
        if (this.queryParamMode == MultiQueryParamMode.COMMA_SEPARATED) {
            sb.append(queryParamName).append("=");
        }
        block5: for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Value is null");
            }
            sb.append(prefix);
            String queryParamValue = this.encode ? Encode.encodeQueryParamAsIs(value.toString()) : value.toString();
            switch (this.queryParamMode) {
                case MULTI_PAIRS: {
                    prefix = "&";
                    sb.append(queryParamName).append("=").append(queryParamValue);
                    continue block5;
                }
                case COMMA_SEPARATED: {
                    prefix = ",";
                    sb.append(queryParamValue);
                    continue block5;
                }
                case ARRAY_PAIRS: {
                    prefix = "&";
                    String queryParamConnector = this.arrayPairsConnector(values);
                    sb.append(queryParamName).append(queryParamConnector).append(queryParamValue);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + this.queryParamMode);
                }
            }
        }
        this.query = sb.toString();
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        if (this.query == null) {
            this.query = "";
        } else {
            sb.append(this.query).append("&");
        }
        if (values != null) {
            String queryParamName;
            String string = queryParamName = this.encode ? Encode.encodeQueryParam(name) : name;
            if (this.queryParamMode == MultiQueryParamMode.COMMA_SEPARATED) {
                sb.append(queryParamName).append("=");
            }
            block5: for (Object value : values) {
                if (value == null) {
                    throw new IllegalArgumentException("Value is null");
                }
                sb.append(prefix);
                String queryParamValue = this.encode ? Encode.encodeQueryParam(value.toString()) : value.toString();
                switch (this.queryParamMode) {
                    case MULTI_PAIRS: {
                        prefix = "&";
                        sb.append(queryParamName).append("=").append(queryParamValue);
                        continue block5;
                    }
                    case COMMA_SEPARATED: {
                        prefix = ",";
                        sb.append(queryParamValue);
                        continue block5;
                    }
                    case ARRAY_PAIRS: {
                        prefix = "&";
                        String queryParamConnector = this.arrayPairsConnector(values);
                        sb.append(queryParamName).append(queryParamConnector).append(queryParamValue);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + this.queryParamMode);
                    }
                }
            }
        }
        this.query = sb.toString();
        return this;
    }

    private String arrayPairsConnector(Object[] values) {
        return values.length == 1 ? "=" : "[]=";
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (this.query == null || this.query.isEmpty()) {
            return this.queryParam(name, values);
        }
        String[] params = this.query.split("&");
        this.query = null;
        String replacedName = Encode.encodeQueryParam(name);
        for (String param : params) {
            String paramName;
            int pos = param.indexOf(61);
            if (pos < 0 ? param.equals(replacedName) : (paramName = param.substring(0, pos)).equals(replacedName)) continue;
            this.query = this.query == null ? "" : this.query + "&";
            this.query = this.query + param;
        }
        if (values == null || values.length == 0) {
            return this;
        }
        return this.queryParam(name, values);
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (segments == null) {
            throw new IllegalArgumentException("Segments parameter is null");
        }
        for (String segment : segments) {
            if (segment == null) {
                throw new IllegalArgumentException("Segment is null");
            }
            this.path(Encode.encodePathSegment(segment));
        }
        return this;
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildFromValues(false, true, values);
    }

    public UriBuilder replacePath(String path) {
        if (path == null) {
            this.path = null;
            return this;
        }
        this.path = Encode.encodePath(path);
        return this;
    }

    public URI build(Object[] values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Values parameter is null");
        }
        return this.buildFromValues(encodeSlashInPath, false, values);
    }

    public String toTemplate() {
        return this.buildString(Map.of(), true, true, true);
    }

    public UriBuilder resolveTemplate(String name, Object value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value parameter is null");
        }
        return this.resolveTemplates(Map.of(name, value));
    }

    public UriBuilder resolveTemplates(Map<String, Object> templateValues) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("TemplateValues parameter is null");
        }
        this.checkForNullKeysOrValues(templateValues);
        return this.uriTemplate(this.buildCharSequence(templateValues, false, true, true));
    }

    public UriBuilder resolveTemplate(String name, Object value, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value parameter is null");
        }
        return this.uriTemplate(this.buildCharSequence(Map.of(name, value), false, true, encodeSlashInPath));
    }

    public UriBuilder resolveTemplateFromEncoded(String name, Object value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value parameter is null");
        }
        return this.uriTemplate(this.buildCharSequence(Map.of(name, value), true, true, true));
    }

    public UriBuilder resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("TemplateValues parameter is null");
        }
        this.checkForNullKeysOrValues(templateValues);
        return this.uriTemplate(this.buildCharSequence(templateValues, false, true, encodeSlashInPath));
    }

    public UriBuilder resolveTemplatesFromEncoded(Map<String, Object> templateValues) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("TemplateValues parameter is null");
        }
        this.checkForNullKeysOrValues(templateValues);
        return this.uriTemplate(this.buildCharSequence(templateValues, true, true, true));
    }

    private void checkForNullKeysOrValues(Map<?, ?> map) {
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (e.getKey() == null) {
                throw new IllegalArgumentException("map key null");
            }
            if (e.getValue() != null) continue;
            throw new IllegalArgumentException("map value null");
        }
    }

    private void checkForNullValues(Object[] values) {
        for (Object value : values) {
            if (value != null) continue;
            throw new IllegalArgumentException("array value null");
        }
    }

    private static enum MultiQueryParamMode {
        MULTI_PAIRS,
        COMMA_SEPARATED,
        ARRAY_PAIRS;

    }

    private static final class URITemplateParametersMap
    extends HashMap<String, Object> {
        private final Object[] parameterValues;
        private int index;

        private URITemplateParametersMap(Object ... parameterValues) {
            this.parameterValues = parameterValues;
        }

        @Override
        public Object get(Object key) {
            Object object;
            if (!super.containsKey(key) && this.index != this.parameterValues.length) {
                object = this.parameterValues[this.index++];
                super.put((String)key, object);
            } else {
                object = super.get(key);
            }
            return object;
        }

        @Override
        public boolean containsKey(Object key) {
            boolean containsKey = super.containsKey(key);
            if (!containsKey && this.index != this.parameterValues.length) {
                super.put((String)key, this.parameterValues[this.index++]);
                containsKey = true;
            }
            return containsKey;
        }
    }

    private static final class InternalMultivaluedHashMap<Key, Value>
    extends MultivaluedHashMap<Key, Value>
    implements MultivaluedMap<Key, Value> {
        private static final long serialVersionUID = 4136263572124588039L;

        private InternalMultivaluedHashMap() {
        }

        public List<Value> put(Key key, List<Value> value) {
            if (value != null) {
                value = new LinkedList<Value>(value);
            }
            return super.put(key, value);
        }

        public void putAll(Map<? extends Key, ? extends List<Value>> m) {
            for (Map.Entry<Key, List<Value>> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

