/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import jakarta.annotation.Priority;
import jakarta.ws.rs.core.MediaType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@Internal
public final class JaxRsUtils {
    public static <T> void sortByPriority(List<T> values) {
        JaxRsUtils.sortByPriority(values, false);
    }

    public static <T> void sortByPriorityReversed(List<T> values) {
        JaxRsUtils.sortByPriority(values, true);
    }

    private static <T> void sortByPriority(List<T> values, boolean reverse) {
        Comparator<Object> comparator = Comparator.comparingInt(JaxRsUtils::getPriorityOrder);
        if (reverse) {
            comparator = comparator.reversed();
        }
        values.sort(comparator);
    }

    public static int getPriorityOrder(Object o1) {
        return Arrays.stream(o1.getClass().getAnnotations()).filter(annotation -> annotation instanceof Priority).mapToInt(an -> ((Priority)an).value()).findFirst().orElse(0);
    }

    public static <T> T requireNonNull(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument [" + name + "] cannot be null");
        }
        return value;
    }

    public static MediaType convert(io.micronaut.http.MediaType mediaType) {
        return mediaType == null ? null : MediaType.valueOf((String)mediaType.toString());
    }

    public static io.micronaut.http.MediaType convert(MediaType mediaType) {
        return mediaType == null ? null : io.micronaut.http.MediaType.of((String)mediaType.toString());
    }
}

