/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.common.LinkImpl;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@Internal
final class LinkBuilderImpl
implements Link.Builder {
    private final Map<String, String> map = new HashMap<String, String>();
    private UriBuilder uriBuilder;
    private URI baseUri;

    LinkBuilderImpl() {
    }

    public Link.Builder link(Link link) {
        this.uriBuilder = UriBuilder.fromUri((URI)link.getUri());
        this.map.clear();
        this.map.putAll(link.getParams());
        return this;
    }

    public Link.Builder link(String link) {
        Link l = LinkImpl.valueOf(link);
        return this.link(l);
    }

    public Link.Builder uriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder.clone();
        return this;
    }

    public Link.Builder uri(URI uri) {
        JaxRsUtils.requireNonNull("uri", uri);
        this.uriBuilder = UriBuilder.fromUri((URI)uri);
        return this;
    }

    public Link.Builder uri(String uri) throws IllegalArgumentException {
        JaxRsUtils.requireNonNull("uri", uri);
        this.uriBuilder = UriBuilder.fromUri((String)uri);
        return this;
    }

    public Link.Builder rel(String rel) {
        JaxRsUtils.requireNonNull("rel", rel);
        String rels = this.map.get("rel");
        this.param("rel", (String)(rels == null ? rel : rels + " " + rel));
        return this;
    }

    public Link.Builder title(String title) {
        JaxRsUtils.requireNonNull("title", title);
        this.param("title", title);
        return this;
    }

    public Link.Builder type(String type) {
        JaxRsUtils.requireNonNull("type", type);
        this.param("type", type);
        return this;
    }

    public Link.Builder param(String name, String value) throws IllegalArgumentException {
        JaxRsUtils.requireNonNull("name", name);
        JaxRsUtils.requireNonNull("value", value);
        this.map.put(name, value);
        return this;
    }

    public Link build(Object ... values) throws UriBuilderException {
        JaxRsUtils.requireNonNull("values", values);
        URI built = this.uriBuilder == null ? this.baseUri : this.uriBuilder.build(values);
        if (!built.isAbsolute() && this.baseUri != null) {
            built = this.baseUri.resolve(built);
        }
        return new LinkImpl(built, this.map);
    }

    public Link buildRelativized(URI uri, Object ... values) {
        URI built;
        JaxRsUtils.requireNonNull("uri", uri);
        JaxRsUtils.requireNonNull("values", values);
        URI with = built = this.uriBuilder.build(values);
        if (this.baseUri != null) {
            with = this.baseUri.resolve(built);
        }
        return new LinkImpl(uri.relativize(with), this.map);
    }

    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }
}

