/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.common.MediaTypeHeaderDelegate;
import io.micronaut.jaxrs.common.ParameterParser;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

@Internal
class NewCookieHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<Object> {
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";

    NewCookieHeaderDelegate() {
    }

    public Object fromString(String newCookie) throws IllegalArgumentException {
        JaxRsUtils.requireNonNull("newCookie", newCookie);
        String cookieName = null;
        String cookieValue = null;
        String comment = null;
        String domain = null;
        int maxAge = -1;
        String path = null;
        boolean secure = false;
        int version = 1;
        boolean httpOnly = false;
        Date expiry = null;
        ParameterParser parser = new ParameterParser();
        Map<String, String> map = parser.parse(newCookie, ';');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name.equalsIgnoreCase("Comment")) {
                comment = value;
                continue;
            }
            if (name.equalsIgnoreCase("Domain")) {
                domain = value;
                continue;
            }
            if (name.equalsIgnoreCase("Max-Age")) {
                maxAge = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("Path")) {
                path = value;
                continue;
            }
            if (name.equalsIgnoreCase("Secure")) {
                secure = true;
                continue;
            }
            if (name.equalsIgnoreCase("Version")) {
                version = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("HttpOnly")) {
                httpOnly = true;
                continue;
            }
            if (name.equalsIgnoreCase("Expires")) {
                try {
                    expiry = new SimpleDateFormat(OLD_COOKIE_PATTERN, Locale.US).parse(value);
                }
                catch (ParseException parseException) {}
                continue;
            }
            cookieName = name;
            cookieValue = value;
        }
        if (cookieValue == null) {
            cookieValue = "";
        }
        return ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(cookieName).value(cookieValue)).path(path)).domain(domain)).version(version)).comment(comment)).maxAge(maxAge)).expiry(expiry)).secure(secure)).httpOnly(httpOnly)).build();
    }

    public String toString(Object value) {
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        NewCookie cookie = (NewCookie)value;
        StringBuilder b = new StringBuilder();
        b.append(cookie.getName()).append('=');
        if (cookie.getValue() != null) {
            this.quote(b, cookie.getValue());
        }
        b.append(";").append("Version=").append(cookie.getVersion());
        if (cookie.getComment() != null) {
            b.append(";Comment=");
            this.quote(b, cookie.getComment());
        }
        if (cookie.getDomain() != null) {
            b.append(";Domain=");
            this.quote(b, cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            b.append(";Path=");
            b.append(cookie.getPath());
        }
        if (cookie.getMaxAge() != -1) {
            b.append(";Max-Age=");
            b.append(cookie.getMaxAge());
        }
        if (cookie.getExpiry() != null) {
            b.append(";Expires=");
            b.append(new SimpleDateFormat(OLD_COOKIE_PATTERN).format(cookie.getExpiry()));
        }
        if (cookie.isSecure()) {
            b.append(";Secure");
        }
        if (cookie.isHttpOnly()) {
            b.append(";HttpOnly");
        }
        return b.toString();
    }

    private void quote(StringBuilder b, String value) {
        if (MediaTypeHeaderDelegate.quoted(value)) {
            b.append('\"');
            b.append(value);
            b.append('\"');
        } else {
            b.append(value);
        }
    }
}

