/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

@Internal
public final class ByteArrayByteBuffer<T>
implements io.micronaut.core.io.buffer.ByteBuffer<T> {
    private final byte[] underlyingBytes;
    private int readerIndex;
    private int writerIndex;

    public ByteArrayByteBuffer(byte[] underlyingBytes) {
        this(underlyingBytes, underlyingBytes.length);
    }

    public ByteArrayByteBuffer(byte[] underlyingBytes, int capacity) {
        if (capacity < underlyingBytes.length) {
            this.underlyingBytes = Arrays.copyOf(underlyingBytes, capacity);
        } else if (capacity > underlyingBytes.length) {
            this.underlyingBytes = new byte[capacity];
            System.arraycopy(underlyingBytes, 0, this.underlyingBytes, 0, underlyingBytes.length);
        } else {
            this.underlyingBytes = underlyingBytes;
        }
    }

    public T asNativeBuffer() {
        throw new IllegalStateException("Not supported");
    }

    public int readableBytes() {
        return this.underlyingBytes.length - this.readerIndex;
    }

    public int writableBytes() {
        return this.underlyingBytes.length - this.writerIndex;
    }

    public int maxCapacity() {
        return this.underlyingBytes.length;
    }

    public io.micronaut.core.io.buffer.ByteBuffer capacity(int capacity) {
        return new ByteArrayByteBuffer<T>(this.underlyingBytes, capacity);
    }

    public int readerIndex() {
        return this.readerIndex;
    }

    public io.micronaut.core.io.buffer.ByteBuffer readerIndex(int readPosition) {
        this.readerIndex = Math.min(readPosition, this.underlyingBytes.length - 1);
        return this;
    }

    public int writerIndex() {
        return this.writerIndex;
    }

    public io.micronaut.core.io.buffer.ByteBuffer writerIndex(int position) {
        this.writerIndex = Math.min(position, this.underlyingBytes.length - 1);
        return this;
    }

    public byte read() {
        return this.underlyingBytes[this.readerIndex++];
    }

    public CharSequence readCharSequence(int length, Charset charset) {
        String s = new String(this.underlyingBytes, this.readerIndex, length, charset);
        this.readerIndex += length;
        return s;
    }

    public io.micronaut.core.io.buffer.ByteBuffer read(byte[] destination) {
        int count = Math.min(this.readableBytes(), destination.length);
        System.arraycopy(this.underlyingBytes, this.readerIndex, destination, 0, count);
        this.readerIndex += count;
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer read(byte[] destination, int offset, int length) {
        int count = Math.min(this.readableBytes(), Math.min(destination.length - offset, length));
        System.arraycopy(this.underlyingBytes, this.readerIndex, destination, offset, count);
        this.readerIndex += count;
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(byte b) {
        this.underlyingBytes[this.writerIndex++] = b;
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(byte[] source) {
        int count = Math.min(this.writableBytes(), source.length);
        System.arraycopy(source, 0, this.underlyingBytes, this.writerIndex, count);
        this.writerIndex += count;
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(CharSequence source, Charset charset) {
        this.write(source.toString().getBytes(charset));
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(byte[] source, int offset, int length) {
        int count = Math.min(this.writableBytes(), length);
        System.arraycopy(source, offset, this.underlyingBytes, this.writerIndex, count);
        this.writerIndex += count;
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(io.micronaut.core.io.buffer.ByteBuffer ... buffers) {
        io.micronaut.core.io.buffer.ByteBuffer[] var2 = buffers;
        int var3 = buffers.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            io.micronaut.core.io.buffer.ByteBuffer buffer = var2[var4];
            this.write(buffer.toByteArray());
        }
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer write(ByteBuffer ... buffers) {
        ByteBuffer[] var2 = buffers;
        int var3 = buffers.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            ByteBuffer buffer = var2[var4];
            this.write(buffer.array());
        }
        return this;
    }

    public io.micronaut.core.io.buffer.ByteBuffer slice(int index, int length) {
        return new ByteArrayByteBuffer<T>(Arrays.copyOfRange(this.underlyingBytes, index, index + length), length);
    }

    public ByteBuffer asNioBuffer() {
        return ByteBuffer.wrap(this.underlyingBytes, this.readerIndex, this.readableBytes());
    }

    public ByteBuffer asNioBuffer(int index, int length) {
        return ByteBuffer.wrap(this.underlyingBytes, index, length);
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.underlyingBytes, this.readerIndex, this.readableBytes());
    }

    public OutputStream toOutputStream() {
        throw new IllegalStateException("Not implemented");
    }

    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.underlyingBytes, this.readerIndex, this.readableBytes());
    }

    public String toString(Charset charset) {
        return new String(this.underlyingBytes, this.readerIndex, this.readableBytes(), charset);
    }

    public int indexOf(byte b) {
        for (int i = this.readerIndex; i < this.underlyingBytes.length; ++i) {
            if (this.underlyingBytes[i] != b) continue;
            return i;
        }
        return -1;
    }

    public byte getByte(int index) {
        return this.underlyingBytes[index];
    }
}

