/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.ext.RuntimeDelegate;

@Internal
final class EntityTagDelegate
implements RuntimeDelegate.HeaderDelegate<EntityTag> {
    EntityTagDelegate() {
    }

    public EntityTag fromString(String value) throws IllegalArgumentException {
        JaxRsUtils.requireNonNull("value", value);
        boolean weakTag = false;
        if (value.startsWith("W/")) {
            weakTag = true;
            value = value.substring(2);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return new EntityTag(value, weakTag);
    }

    public String toString(EntityTag value) {
        String weak = value.isWeak() ? "W/" : "";
        return weak + "\"" + value.getValue() + "\"";
    }
}

