/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMessage;
import jakarta.ws.rs.ProcessingException;
import java.util.Optional;

@Internal
public class HttpMessageEntityReader {
    public static final HttpMessageEntityReader DEFAULT = new HttpMessageEntityReader();

    public <T> T readEntity(HttpMessage<?> message, Argument<T> entityType) {
        T result = message.getBody(entityType).orElse(null);
        if (result == null) {
            Optional body = message.getBody(String.class);
            if (body.isEmpty()) {
                return null;
            }
            return (T)body.flatMap(str -> ConversionService.SHARED.convert(str, entityType)).orElseThrow(() -> new ProcessingException("Cannot read an entity of type " + entityType));
        }
        return result;
    }

    public <T> T readEntity(ByteBuffer<?> byteBuffer, Argument<T> entityType) {
        return ConversionService.SHARED.convert((Object)byteBuffer.toByteArray(), entityType).orElse(null);
    }
}

