/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.context.BeanRegistration;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsArgumentUtil;
import io.micronaut.jaxrs.common.JaxRsGenericEntity;
import io.micronaut.jaxrs.common.JaxRsIOException;
import io.micronaut.jaxrs.common.JaxRsInterceptedWrite;
import io.micronaut.jaxrs.common.JaxRsMessageBodyHandlerRegistry;
import io.micronaut.jaxrs.common.NameBindingPredicate;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;

@Internal
@Singleton
final class JaxRsGenericEntityMessageBodyWriter<T>
implements MessageBodyWriter<GenericEntity<T>> {
    private final JaxRsMessageBodyHandlerRegistry jaxRsMessageBodyHandlerRegistry;
    private final MessageBodyHandlerRegistry registry;
    private final List<BeanRegistration<WriterInterceptor>> writerInterceptorsRegistrations;
    private final NameBindingPredicate nameBindingPredicate;

    JaxRsGenericEntityMessageBodyWriter(JaxRsMessageBodyHandlerRegistry jaxRsMessageBodyHandlerRegistry, MessageBodyHandlerRegistry registry, List<BeanRegistration<WriterInterceptor>> writerInterceptorsRegistrations, NameBindingPredicate nameBindingPredicate) {
        this.jaxRsMessageBodyHandlerRegistry = jaxRsMessageBodyHandlerRegistry;
        this.registry = registry;
        this.writerInterceptorsRegistrations = writerInterceptorsRegistrations;
        this.nameBindingPredicate = nameBindingPredicate;
    }

    public void writeTo(@NonNull Argument<GenericEntity<T>> type, @NonNull MediaType mediaType, GenericEntity<T> genericEntity, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        Argument<T> argument;
        OutputStream originalOutputStream = outputStream;
        ByteArrayOutputStream delegateEntityStream = null;
        if (genericEntity instanceof JaxRsGenericEntity) {
            JaxRsGenericEntity jaxRsGenericEntity = (JaxRsGenericEntity)genericEntity;
            argument = jaxRsGenericEntity.asArgument();
            delegateEntityStream = jaxRsGenericEntity.getDelegateEntityStream();
            OutputStream customEntityStream = jaxRsGenericEntity.getCustomEntityStream();
            if (customEntityStream != null) {
                outputStream = customEntityStream;
            }
        } else {
            argument = JaxRsArgumentUtil.from(genericEntity);
        }
        Object entity = genericEntity.getEntity();
        if (this.writerInterceptorsRegistrations.isEmpty()) {
            this.write(argument, mediaType, entity, outgoingHeaders, outputStream);
        } else {
            new JaxRsInterceptedWrite<T>(this.writerInterceptorsRegistrations, this.nameBindingPredicate){

                @Override
                protected void writeToAfterInterception(Argument<Object> argument, MediaType mediaType, Object entity, MutableHeaders outgoingHeaders, OutputStream outputStream) {
                    JaxRsGenericEntityMessageBodyWriter.this.write(argument, mediaType, entity, outgoingHeaders, outputStream);
                }
            }.intercept(argument, mediaType, entity, outgoingHeaders, outputStream);
        }
        if (delegateEntityStream != null) {
            try {
                originalOutputStream.write(delegateEntityStream.toByteArray());
            }
            catch (IOException e) {
                throw new JaxRsIOException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <K> void write(Argument<K> argument, MediaType mediaType, K entity, MutableHeaders outgoingHeaders, OutputStream outputStream) {
        List<MediaType> mediaTypes = List.of(mediaType);
        Optional writer = this.jaxRsMessageBodyHandlerRegistry.findWriter(argument, mediaTypes);
        if (writer.isEmpty()) {
            writer = this.registry.findWriter(argument, mediaTypes);
        }
        if (writer.isEmpty()) {
            Optional stringWriter = this.registry.findWriter(Argument.STRING, mediaTypes);
            if (!stringWriter.isPresent()) throw new CodecException("Could not find MessageBodyWriter for media type " + mediaType + " for argument " + argument);
            ((MessageBodyWriter)stringWriter.get()).writeTo(Argument.STRING, mediaType, (Object)entity.toString(), outgoingHeaders, outputStream);
            return;
        } else {
            writer.get().writeTo(argument, mediaType, entity, outgoingHeaders, outputStream);
        }
    }
}

