/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Headers;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

@Internal
public class JaxRsHeadersMultivaluedMap
extends AbstractMap<String, List<String>>
implements MultivaluedMap<String, String> {
    private final Headers headers;

    public JaxRsHeadersMultivaluedMap(Headers headers) {
        this.headers = headers;
    }

    private static Map<Object, Integer> counts(List<?> list) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Object o : list) {
            map.compute(o, (k, v) -> v == null ? 1 : v + 1);
        }
        return map;
    }

    public void putSingle(String key, String value) {
        throw new IllegalStateException("Not supported");
    }

    public void add(String key, String value) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public List<String> remove(Object key) {
        throw new IllegalStateException("Not supported");
    }

    public String getFirst(String key) {
        List l = (List)this.get(key);
        return l == null || l.isEmpty() ? null : (String)l.get(0);
    }

    @SafeVarargs
    public final void addAll(String key, String ... newValues) {
        this.addAll(key, Arrays.asList(newValues));
    }

    public void addAll(String key, List<String> valueList) {
        for (String v : valueList) {
            this.add(key, v);
        }
    }

    public void addFirst(String key, String value) {
        List old = (List)this.get(key);
        this.put(key, Stream.concat(Stream.of(value), old.stream()).toList());
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.asMap().entrySet();
    }

    @Override
    public List<String> put(String key, List<String> value) {
        throw new IllegalStateException("Not supported");
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, String> otherMap) {
        if (!this.keySet().equals(otherMap.keySet())) {
            return false;
        }
        for (String key : otherMap.keySet()) {
            List l = (List)this.get(key);
            List r = (List)otherMap.get((Object)key);
            if (l.size() != r.size()) {
                return false;
            }
            if (JaxRsHeadersMultivaluedMap.counts(l).equals(JaxRsHeadersMultivaluedMap.counts(r))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }
}

