/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsIOException;
import io.micronaut.jaxrs.common.JaxRsMutableObjectHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

@Internal
public final class JaxRsMessageBodyWriter<T>
implements io.micronaut.http.body.MessageBodyWriter<T> {
    private final List<MediaType> produces;
    private final MessageBodyWriter<T> delegate;

    public JaxRsMessageBodyWriter(List<MediaType> produces, MessageBodyWriter<T> delegate) {
        this.produces = produces;
        this.delegate = delegate;
    }

    public JaxRsMessageBodyWriter(AnnotationMetadata annotationMetadata, MessageBodyWriter<T> delegate) {
        this(JaxRsMessageBodyWriter.asMediaTypes(annotationMetadata), delegate);
    }

    private static List<MediaType> asMediaTypes(AnnotationMetadata annotationMetadata) {
        AnnotationValue producesAnnotationValue = annotationMetadata.getAnnotation(Produces.class);
        if (producesAnnotationValue == null) {
            return List.of();
        }
        return Arrays.stream(producesAnnotationValue.stringValues()).map(MediaType::of).toList();
    }

    public boolean isWriteable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return this.delegate.isWriteable(type.getType(), type.asType(), type.getAnnotationMetadata().synthesizeAll(), JaxRsUtils.convert(mediaType));
    }

    public void writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        try {
            JaxRsMutableObjectHeadersMultivaluedMap httpHeaders = new JaxRsMutableObjectHeadersMultivaluedMap(outgoingHeaders);
            this.delegate.writeTo(object, type.getType(), type.asType(), type.getAnnotationMetadata().synthesizeAll(), JaxRsUtils.convert(mediaType), (MultivaluedMap)httpHeaders, outputStream);
            if (!httpHeaders.containsKey("Content-Type")) {
                if (mediaType == null || JaxRsUtils.convert(mediaType).isWildcardType()) {
                    if (this.produces.size() == 1) {
                        httpHeaders.add("Content-Type", (Object)this.produces.get(0).toString());
                    }
                } else {
                    httpHeaders.add("Content-Type", (Object)mediaType.toString());
                }
            }
        }
        catch (IOException e) {
            throw new JaxRsIOException("Cannot write to", e);
        }
    }
}

