/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
final class JaxRsMetadataMultivaluedMap
extends AbstractMap<String, List<Object>>
implements MultivaluedMap<String, Object> {
    private final Map<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();

    JaxRsMetadataMultivaluedMap() {
    }

    private static Map<Object, Integer> counts(List<?> list) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Object o : list) {
            map.compute(o, (k, v) -> v == null ? 1 : v + 1);
        }
        return map;
    }

    public void putSingle(String key, Object value) {
        this.map.put(key, new ArrayList<Object>(List.of(value)));
    }

    @Override
    public List<Object> put(String key, List<Object> value) {
        this.map.computeIfAbsent(key, k -> new ArrayList()).addAll(value);
        return value;
    }

    public void add(String key, Object value) {
        this.map.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    @Override
    public List<Object> remove(Object key) {
        return this.map.remove(key);
    }

    public Object getFirst(String key) {
        List l = (List)this.get(key);
        return l == null || l.isEmpty() ? null : l.get(0);
    }

    @SafeVarargs
    public final void addAll(String key, Object ... newValues) {
        this.addAll(key, Arrays.asList(newValues));
    }

    public void addAll(String key, List<Object> valueList) {
        for (Object v : valueList) {
            this.add(key, v);
        }
    }

    public void addFirst(String key, Object value) {
        this.map.computeIfAbsent(key, k -> new ArrayList()).add(0, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<Object>> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public Set<Map.Entry<String, List<Object>>> entrySet() {
        return this.map.entrySet();
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, Object> otherMap) {
        if (!this.keySet().equals(otherMap.keySet())) {
            return false;
        }
        for (String key : otherMap.keySet()) {
            List l = (List)this.get(key);
            List r = (List)otherMap.get((Object)key);
            if (l.size() != r.size()) {
                return false;
            }
            if (JaxRsMetadataMultivaluedMap.counts(l).equals(JaxRsMetadataMultivaluedMap.counts(r))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }
}

