/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseProvider;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.jaxrs.common.HttpMessageEntityReader;
import io.micronaut.jaxrs.common.JaxRsMutableHttpHeaders;
import io.micronaut.jaxrs.common.JaxRsMutableObjectHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsResponse;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

@Internal
public final class JaxRsMutableResponse
extends JaxRsResponse
implements HttpResponseProvider {
    private final MutableHttpResponse<?> mutableHttpResponse;
    private InputStream entityStream;

    public JaxRsMutableResponse(MutableHttpResponse<?> mutableHttpResponse) {
        super((HttpResponse<?>)mutableHttpResponse);
        this.mutableHttpResponse = mutableHttpResponse;
    }

    public JaxRsMutableResponse(MutableHttpResponse<?> mutableHttpResponse, HttpMessageEntityReader entityReader) {
        super((HttpResponse<?>)mutableHttpResponse, entityReader);
        this.mutableHttpResponse = mutableHttpResponse;
    }

    @Override
    public boolean hasEntity() {
        return this.entityStream != null || super.hasEntity();
    }

    @Override
    public <T> T readEntity(Argument<T> entityType) {
        if (this.entityStream != null) {
            byte[] result;
            if (entityType.getType().equals(InputStream.class)) {
                return (T)this.entityStream;
            }
            try {
                result = this.entityStream.readAllBytes();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try {
                this.entityStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mutableHttpResponse.body((Object)result);
            this.entityStream = null;
        }
        return super.readEntity(entityType);
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        return JaxRsMutableHttpHeaders.forResponse(this.mutableHttpResponse.getHeaders()).getRequestHeaders();
    }

    @Override
    public JaxRsMutableResponse withEntityReader(HttpMessageEntityReader entityReader) {
        return new JaxRsMutableResponse(this.mutableHttpResponse, entityReader);
    }

    public MutableHttpResponse<?> getResponse() {
        return this.mutableHttpResponse;
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return new JaxRsMutableObjectHeadersMultivaluedMap((MutableHeaders)this.mutableHttpResponse.getHeaders());
    }

    public InputStream getEntityStream() {
        if (this.entityStream == null) {
            byte[] bytes = this.mutableHttpResponse.getBody(byte[].class).orElse(new byte[0]);
            this.entityStream = new ByteArrayInputStream(bytes);
        }
        return this.entityStream;
    }

    public void setEntityStream(InputStream entityStream) {
        this.entityStream = entityStream;
    }

    @Override
    public void close() {
        if (this.entityStream != null) {
            try {
                this.entityStream.close();
                this.entityStream = null;
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        super.close();
    }
}

