/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Headers;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

@Internal
@Singleton
public class JaxRsObjectHeadersMultivaluedMap
extends AbstractMap<String, List<Object>>
implements MultivaluedMap<String, Object> {
    private final Headers headers;

    JaxRsObjectHeadersMultivaluedMap(Headers headers) {
        this.headers = headers;
    }

    private static Map<Object, Integer> counts(List<?> list) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Object o : list) {
            map.compute(o, (k, v) -> v == null ? 1 : v + 1);
        }
        return map;
    }

    public void putSingle(String key, Object value) {
        throw new IllegalStateException("Not supported");
    }

    public void add(String key, Object value) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public List<Object> remove(Object key) {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public List<Object> put(String key, List<Object> value) {
        throw new IllegalStateException("Not supported");
    }

    public Object getFirst(String key) {
        Object l = this.get(key);
        return l == null || l.isEmpty() ? null : l.get(0);
    }

    @Override
    public List<Object> get(Object key) {
        return new ArrayList<Object>(this.headers.getAll((CharSequence)key.toString()));
    }

    @SafeVarargs
    public final void addAll(String key, Object ... newValues) {
        this.addAll(key, Arrays.asList(newValues));
    }

    public void addAll(String key, List<Object> valueList) {
        for (Object v : valueList) {
            this.add(key, v);
        }
    }

    public void addFirst(String key, Object value) {
        this.computeIfPresent(key, (k, old) -> Stream.concat(Stream.of(value), old.stream()).toList());
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<Object>> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    @Override
    public Set<Map.Entry<String, List<Object>>> entrySet() {
        return this.headers.asMap().entrySet();
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, Object> otherMap) {
        if (!this.keySet().equals(otherMap.keySet())) {
            return false;
        }
        for (String key : otherMap.keySet()) {
            Object l = this.get(key);
            List r = (List)otherMap.get((Object)key);
            if (l.size() != r.size()) {
                return false;
            }
            if (JaxRsObjectHeadersMultivaluedMap.counts(l).equals(JaxRsObjectHeadersMultivaluedMap.counts(r))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.contains(key.toString());
    }
}

