/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common.body.standard;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.io.IOUtils;
import io.micronaut.jaxrs.common.JaxRsIOException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

@Order(value=0x7FFFFFFF)
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Prototype
@Internal
final class JaxRsBooleanMessageBodyReaderWriter
implements MessageBodyReader<Boolean>,
MessageBodyWriter<Boolean> {
    JaxRsBooleanMessageBodyReaderWriter() {
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == Boolean.class && MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(type, genericType, annotations, mediaType);
    }

    public Boolean readFrom(Class<Boolean> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Boolean bl;
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream, StandardCharsets.UTF_8));
        try {
            String s = IOUtils.readText((BufferedReader)reader);
            bl = Boolean.parseBoolean(s);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JaxRsIOException(e);
            }
        }
        reader.close();
        return bl;
    }

    public void writeTo(Boolean aBoolean, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            entityStream.write(aBoolean.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new JaxRsIOException(e);
        }
    }
}

