/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common.body.standard;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.form.FormUrlEncodedDecoder;
import io.micronaut.jaxrs.common.JaxRsIOException;
import io.micronaut.jaxrs.common.body.standard.DefaultFormUrlEncodedDecoder;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@Order(value=0x7FFFFFFF)
@Consumes(value={"application/x-www-form-urlencoded"})
@Internal
@Prototype
public final class JaxRsMultivaluedStringStringMapMessageBodyReader
implements MessageBodyReader<MultivaluedMap<String, String>> {
    private final FormUrlEncodedDecoder formUrlEncodedDecoder = new DefaultFormUrlEncodedDecoder();

    public boolean isReadable(@NonNull Argument<MultivaluedMap<String, String>> type, @Nullable MediaType mediaType) {
        return super.isReadable(type, mediaType) && MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)mediaType);
    }

    @Nullable
    public MultivaluedMap<String, String> read(@NonNull Argument<MultivaluedMap<String, String>> type, @Nullable MediaType mediaType, @NonNull Headers httpHeaders, @NonNull InputStream inputStream) throws CodecException {
        MultivaluedHashMap multivaluedHashMap;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            Map decoded = this.formUrlEncodedDecoder.decode(IOUtils.readText((BufferedReader)reader), mediaType.getCharset().orElse(StandardCharsets.UTF_8));
            MultivaluedHashMap map = new MultivaluedHashMap();
            decoded.forEach((key, value) -> map.add(key, (Object)(value == null ? null : value.toString())));
            multivaluedHashMap = map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JaxRsIOException("Failed to read to a string", e);
            }
        }
        reader.close();
        return multivaluedHashMap;
    }
}

