/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common.body.standard;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.io.IOUtils;
import io.micronaut.jaxrs.common.JaxRsIOException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Order(value=0x7FFFFFFF)
@Prototype
@Internal
public final class JaxRsStringMessageBodyReaderWriter
implements MessageBodyReader<String>,
MessageBodyWriter<String> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return String.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return String.class.isAssignableFrom(type);
    }

    public String readFrom(Class<String> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        return JaxRsStringMessageBodyReaderWriter.readToString(entityStream, mediaType, false);
    }

    static String readToString(InputStream entityStream, MediaType mediaType, boolean requiredNonEmpty) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream, JaxRsStringMessageBodyReaderWriter.getCharset(mediaType)));
        try {
            String text = IOUtils.readText((BufferedReader)reader);
            if (requiredNonEmpty && text.isEmpty()) {
                throw new NoContentException("No content");
            }
            string = text;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JaxRsIOException(e);
            }
        }
        reader.close();
        return string;
    }

    private static Charset getCharset(MediaType mediaType) {
        if (mediaType == null) {
            return StandardCharsets.UTF_8;
        }
        String charsetString = (String)mediaType.getParameters().get("charset");
        if (charsetString != null) {
            return Charset.forName(charsetString);
        }
        return StandardCharsets.UTF_8;
    }

    public void writeTo(String string, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(string.getBytes(JaxRsStringMessageBodyReaderWriter.getCharset(mediaType)));
    }
}

