/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.List;

@Internal
class CacheControlDelegate
implements RuntimeDelegate.HeaderDelegate<CacheControl> {
    public static final CacheControlDelegate INSTANCE = new CacheControlDelegate();
    public static final String NO_CACHE = "no-cache";
    public static final String PRIVATE = "private";

    CacheControlDelegate() {
    }

    private static StringBuilder addDirective(String directive, StringBuilder buffer) {
        if (!buffer.isEmpty()) {
            buffer.append(", ");
        }
        buffer.append(directive);
        return buffer;
    }

    public CacheControl fromString(String value) throws IllegalArgumentException {
        String[] directives;
        JaxRsUtils.requireNonNull("value", value);
        CacheControl result = new CacheControl();
        result.setNoTransform(false);
        block20: for (String directive : directives = value.split(",")) {
            String lowercase;
            directive = directive.trim();
            String[] nv = directive.split("=");
            String name = nv[0].trim();
            String val = null;
            if (nv.length > 1) {
                val = nv[1].trim();
                if (val.startsWith("\"")) {
                    val = val.substring(1);
                }
                if (val.endsWith("\"")) {
                    val = val.substring(0, val.length() - 1);
                }
            }
            switch (lowercase = name.toLowerCase()) {
                case "no-cache": {
                    result.setNoCache(true);
                    if (val == null || val.isEmpty()) continue block20;
                    result.getNoCacheFields().add(val);
                    continue block20;
                }
                case "private": {
                    result.setPrivate(true);
                    if (val == null || val.isEmpty()) continue block20;
                    result.getPrivateFields().add(val);
                    continue block20;
                }
                case "no-store": {
                    result.setNoStore(true);
                    continue block20;
                }
                case "max-age": {
                    if (val == null) {
                        throw new IllegalArgumentException("CacheControl max-age header does not have a value: " + value);
                    }
                    result.setMaxAge(Integer.parseInt(val));
                    continue block20;
                }
                case "s-maxage": {
                    if (val == null) {
                        throw new IllegalArgumentException("CacheControl s-max-age header does not have a value: " + value);
                    }
                    result.setSMaxAge(Integer.parseInt(val));
                    continue block20;
                }
                case "no-transform": {
                    result.setNoTransform(true);
                    continue block20;
                }
                case "must-revalidate": {
                    result.setMustRevalidate(true);
                    continue block20;
                }
                case "proxy-revalidate": {
                    result.setProxyRevalidate(true);
                    continue block20;
                }
                default: {
                    if (val == null) {
                        val = "";
                    }
                    result.getCacheExtension().put(name, val);
                }
            }
        }
        return result;
    }

    public String toString(CacheControl value) {
        List fields;
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        StringBuilder buffer = new StringBuilder();
        if (value.isNoCache()) {
            fields = value.getNoCacheFields();
            if (fields.isEmpty()) {
                CacheControlDelegate.addDirective(NO_CACHE, buffer);
            } else {
                for (String field : value.getNoCacheFields()) {
                    CacheControlDelegate.addDirective(NO_CACHE, buffer).append("=\"").append(field).append("\"");
                }
            }
        }
        if (value.isMustRevalidate()) {
            CacheControlDelegate.addDirective("must-revalidate", buffer);
        }
        if (value.isNoTransform()) {
            CacheControlDelegate.addDirective("no-transform", buffer);
        }
        if (value.isNoStore()) {
            CacheControlDelegate.addDirective("no-store", buffer);
        }
        if (value.isProxyRevalidate()) {
            CacheControlDelegate.addDirective("proxy-revalidate", buffer);
        }
        if (value.getSMaxAge() > -1) {
            CacheControlDelegate.addDirective("s-maxage", buffer).append("=").append(value.getSMaxAge());
        }
        if (value.getMaxAge() > -1) {
            CacheControlDelegate.addDirective("max-age", buffer).append("=").append(value.getMaxAge());
        }
        if (value.isPrivate()) {
            fields = value.getPrivateFields();
            if (fields.isEmpty()) {
                CacheControlDelegate.addDirective(PRIVATE, buffer);
            } else {
                for (String field : value.getPrivateFields()) {
                    CacheControlDelegate.addDirective(PRIVATE, buffer).append("=\"").append(field).append("\"");
                }
            }
        }
        for (String key : value.getCacheExtension().keySet()) {
            String val = (String)value.getCacheExtension().get(key);
            CacheControlDelegate.addDirective(key, buffer);
            if (val == null || val.isEmpty()) continue;
            buffer.append("=\"").append(val).append("\"");
        }
        return buffer.toString();
    }
}

