/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.jaxrs.common.JaxRsArgumentUtil;
import jakarta.ws.rs.core.GenericEntity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Internal
public final class JaxRsGenericEntity<T>
extends GenericEntity<T> {
    private final Argument<T> argument;
    private final ByteArrayOutputStream delegateEntityStream;
    private final OutputStream customEntityStream;

    public JaxRsGenericEntity(T entity, Argument<T> argument, ByteArrayOutputStream delegateEntityStream, OutputStream customEntityStream) {
        super(entity, (Type)argument.getType());
        this.argument = argument;
        this.delegateEntityStream = delegateEntityStream;
        this.customEntityStream = customEntityStream;
    }

    JaxRsGenericEntity(T entity, Annotation[] annotations) {
        super(entity, entity.getClass());
        this.argument = JaxRsArgumentUtil.from(this, annotations);
        this.delegateEntityStream = null;
        this.customEntityStream = null;
    }

    public Argument<T> asArgument() {
        return this.argument;
    }

    public ByteArrayOutputStream getDelegateEntityStream() {
        return this.delegateEntityStream;
    }

    public OutputStream getCustomEntityStream() {
        return this.customEntityStream;
    }
}

