/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.context.BeanRegistration;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsIOException;
import io.micronaut.jaxrs.common.JaxRsMutableHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsReaderInterceptorContext;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.common.NameBindingPredicate;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Internal
public abstract class JaxRsInterceptedRead<T> {
    @Nullable
    private final List<BeanRegistration<ReaderInterceptor>> readerInterceptorsRegistrations;
    private final NameBindingPredicate nameBindingPredicate;

    public JaxRsInterceptedRead(List<BeanRegistration<ReaderInterceptor>> readerInterceptorsRegistrations, NameBindingPredicate nameBindingPredicate) {
        this.nameBindingPredicate = nameBindingPredicate;
        if (readerInterceptorsRegistrations.isEmpty()) {
            throw new IllegalStateException("No ReaderInterceptor found");
        }
        this.readerInterceptorsRegistrations = new ArrayList<BeanRegistration<ReaderInterceptor>>(readerInterceptorsRegistrations);
        JaxRsUtils.sortByPriority(this.readerInterceptorsRegistrations);
    }

    public JaxRsInterceptedRead(List<ReaderInterceptor> readerInterceptor) {
        this(readerInterceptor.stream().map(r -> new BeanRegistration(null, null, r)).toList(), annotationMetadata -> true);
    }

    public final T intercept(@NonNull Argument<T> type, @Nullable MediaType mediaType, @NonNull Headers httpHeaders, @NonNull InputStream inputStream) throws CodecException {
        try {
            List<ReaderInterceptor> readerInterceptors = this.readerInterceptorsRegistrations.stream().filter(br -> this.nameBindingPredicate.test(br.getBeanDefinition())).map(BeanRegistration::getBean).toList();
            Iterator<ReaderInterceptor> iterator = readerInterceptors.iterator();
            if (iterator.hasNext()) {
                JaxRsReaderInterceptorContext context = new JaxRsReaderInterceptorContext(iterator, ctx -> this.readFromAfterInterception(ctx.asArgument(), JaxRsUtils.convert(ctx.getMediaType()), httpHeaders, ctx.getInputStream()), type, JaxRsUtils.convert(mediaType), new JaxRsMutableHeadersMultivaluedMap((MutableHeaders)httpHeaders), inputStream);
                Object value = iterator.next().aroundReadFrom((ReaderInterceptorContext)context);
                if (!type.isInstance(value)) {
                    return (T)ConversionService.SHARED.convertRequired(value, type);
                }
                return (T)value;
            }
            return this.readFromAfterInterception(type, mediaType, httpHeaders, inputStream);
        }
        catch (IOException e) {
            throw new JaxRsIOException("Failed to read", e);
        }
    }

    protected abstract T readFromAfterInterception(@NonNull Argument<Object> var1, @Nullable MediaType var2, @NonNull Headers var3, @NonNull InputStream var4);
}

