/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.context.BeanRegistration;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsIOException;
import io.micronaut.jaxrs.common.JaxRsMutableObjectHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.common.JaxRsWriterInterceptorContext;
import io.micronaut.jaxrs.common.NameBindingPredicate;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Internal
public abstract class JaxRsInterceptedWrite<T> {
    private final List<BeanRegistration<WriterInterceptor>> writerInterceptorsRegistrations;
    private final NameBindingPredicate nameBindingPredicate;

    public JaxRsInterceptedWrite(List<BeanRegistration<WriterInterceptor>> writerInterceptorsRegistrations, NameBindingPredicate nameBindingPredicate) {
        this.nameBindingPredicate = nameBindingPredicate;
        if (writerInterceptorsRegistrations.isEmpty()) {
            throw new IllegalStateException("No WriterInterceptor found");
        }
        this.writerInterceptorsRegistrations = new ArrayList<BeanRegistration<WriterInterceptor>>(writerInterceptorsRegistrations);
        JaxRsUtils.sortByPriority(this.writerInterceptorsRegistrations);
    }

    public JaxRsInterceptedWrite(List<WriterInterceptor> writerInterceptors) {
        this(writerInterceptors.stream().map(i -> new BeanRegistration(null, null, i)).toList(), annotationMetadata -> true);
    }

    public final void intercept(@NonNull Argument<T> type, @NonNull MediaType mediaType, T entity, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        try {
            List<WriterInterceptor> writerInterceptors = this.writerInterceptorsRegistrations.stream().filter(br -> this.nameBindingPredicate.test(br.getBeanDefinition())).map(BeanRegistration::getBean).toList();
            Iterator<WriterInterceptor> iterator = writerInterceptors.iterator();
            JaxRsMutableObjectHeadersMultivaluedMap httpHeaders = new JaxRsMutableObjectHeadersMultivaluedMap(outgoingHeaders);
            if (iterator.hasNext()) {
                JaxRsWriterInterceptorContext context = new JaxRsWriterInterceptorContext(iterator, ctx -> {
                    Object newEntity;
                    Argument<?> argument = ctx.asArgument();
                    if (!argument.isInstance(newEntity = ctx.getEntity())) {
                        newEntity = ConversionService.SHARED.convertRequired(newEntity, argument.getType());
                    }
                    this.writeToAfterInterception(argument, JaxRsUtils.convert(ctx.getMediaType()), newEntity, outgoingHeaders, ctx.getOutputStream());
                }, type, JaxRsUtils.convert(mediaType), httpHeaders, entity, outputStream);
                iterator.next().aroundWriteTo((WriterInterceptorContext)context);
            } else {
                this.writeToAfterInterception(type, mediaType, entity, outgoingHeaders, outputStream);
            }
        }
        catch (IOException e) {
            throw new JaxRsIOException(e);
        }
    }

    protected abstract void writeToAfterInterception(@NonNull Argument<Object> var1, @NonNull MediaType var2, Object var3, @NonNull MutableHeaders var4, @NonNull OutputStream var5);
}

