/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.codec.CodecException;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import io.micronaut.inject.qualifiers.MatchArgumentQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jaxrs.common.JaxRsMessageBodyReader;
import io.micronaut.jaxrs.common.JaxRsMessageBodyWriter;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@Internal
public final class JaxRsMessageBodyHandlerRegistry {
    private static final io.micronaut.http.body.MessageBodyReader<Object> NO_READER = new NoReader();
    private static final io.micronaut.http.body.MessageBodyWriter<Object> NO_WRITER = new NoWriter();
    private final BeanContext beanLocator;
    private final Map<HandlerKey<?>, io.micronaut.http.body.MessageBodyReader<?>> readers = new ConcurrentHashMap(10);
    private final Map<HandlerKey<?>, io.micronaut.http.body.MessageBodyWriter<?>> writers = new ConcurrentHashMap(10);

    public JaxRsMessageBodyHandlerRegistry(BeanContext beanLocators) {
        this.beanLocator = beanLocators;
    }

    private <T> MessageBodyReader<T> findJaxRsReader(Argument<T> type, List<io.micronaut.http.MediaType> mediaTypes) {
        Class theType = type.getType();
        Type genericType = type.asType();
        List<MediaType> types = mediaTypes.stream().map(JaxRsUtils::convert).toList();
        Annotation[] annotations = type.getAnnotationMetadata().synthesizeAll();
        return this.beanLocator.getBeansOfType(Argument.of(MessageBodyReader.class), Qualifiers.byQualifiers((Qualifier[])new Qualifier[]{new MediaTypeQualifier(Argument.of(MessageBodyReader.class, (Argument[])new Argument[]{type}), mediaTypes, Consumes.class), MatchArgumentQualifier.covariant(MessageBodyReader.class, type)})).stream().filter(reader -> types.stream().anyMatch(mediaType -> reader.isReadable(theType, genericType, annotations, mediaType))).findFirst().orElse(null);
    }

    private <T> BeanRegistration<MessageBodyWriter<T>> findJaxRsBodyWriter(Argument<T> type, List<io.micronaut.http.MediaType> mediaTypes) {
        Class theType = type.getType();
        Type genericType = type.asType();
        List<MediaType> types = mediaTypes.stream().map(JaxRsUtils::convert).toList();
        Annotation[] annotations = type.getAnnotationMetadata().synthesizeAll();
        return this.beanLocator.getBeanRegistrations(Argument.of(MessageBodyWriter.class), Qualifiers.byQualifiers((Qualifier[])new Qualifier[]{new MediaTypeQualifier(Argument.of(MessageBodyWriter.class, (Argument[])new Argument[]{type}), mediaTypes, Produces.class), MatchArgumentQualifier.contravariant(MessageBodyWriter.class, type)})).stream().map(br -> br).filter(br -> types.stream().anyMatch(mediaType -> ((MessageBodyWriter)br.getBean()).isWriteable(theType, genericType, annotations, mediaType))).findFirst().orElse(null);
    }

    public <T> Optional<io.micronaut.http.body.MessageBodyReader<T>> findReader(Argument<T> type, List<io.micronaut.http.MediaType> mediaTypes) {
        HandlerKey key;
        io.micronaut.http.body.MessageBodyReader<?> messageBodyReader;
        if (Number.class.isAssignableFrom(type.getType())) {
            type = Argument.of(Number.class, (AnnotationMetadata)type.getAnnotationMetadata(), (Argument[])new Argument[0]);
        }
        if (InputStream.class.isAssignableFrom(type.getType())) {
            type = Argument.of(InputStream.class, (AnnotationMetadata)type.getAnnotationMetadata(), (Argument[])new Argument[0]);
        }
        if ((messageBodyReader = this.readers.get(key = new HandlerKey(type, mediaTypes))) == null) {
            MessageBodyReader<T> delegate = this.findJaxRsReader(type, mediaTypes);
            if (delegate != null) {
                JaxRsMessageBodyReader<T> reader = new JaxRsMessageBodyReader<T>(delegate);
                this.readers.put(key, reader);
                return Optional.of(reader);
            }
            this.readers.put(key, NO_READER);
            return Optional.empty();
        }
        if (messageBodyReader == NO_READER) {
            return Optional.empty();
        }
        return Optional.of(messageBodyReader);
    }

    public <T> Optional<io.micronaut.http.body.MessageBodyWriter<T>> findWriter(Argument<T> type, List<io.micronaut.http.MediaType> mediaTypes) {
        if (type.getType() == Object.class) {
            return Optional.empty();
        }
        HandlerKey<T> key = new HandlerKey<T>(type, mediaTypes);
        io.micronaut.http.body.MessageBodyWriter<?> messageBodyWriter = this.writers.get(key);
        if (messageBodyWriter == null) {
            BeanRegistration<MessageBodyWriter<T>> delegate = this.findJaxRsBodyWriter(type, mediaTypes);
            if (delegate != null) {
                JaxRsMessageBodyWriter micronautWriter = new JaxRsMessageBodyWriter(delegate.getBeanDefinition().getAnnotationMetadata(), (MessageBodyWriter)delegate.bean());
                this.writers.put(key, micronautWriter);
                return Optional.of(micronautWriter);
            }
            this.writers.put(key, NO_WRITER);
            return Optional.empty();
        }
        if (messageBodyWriter == NO_WRITER) {
            return Optional.empty();
        }
        return Optional.of(messageBodyWriter);
    }

    private static final class MediaTypeQualifier<T>
    extends FilteringQualifier<T> {
        private final Argument<?> type;
        private final List<io.micronaut.http.MediaType> mediaTypes;
        private final Class<? extends Annotation> annotationType;

        private MediaTypeQualifier(Argument<?> type, List<io.micronaut.http.MediaType> mediaTypes, Class<? extends Annotation> annotationType) {
            this.type = type;
            this.mediaTypes = mediaTypes;
            this.annotationType = annotationType;
        }

        public <K extends BeanType<T>> Collection<K> filter(Class<T> beanType, Collection<K> candidates) {
            ArrayList<BeanType> all = new ArrayList<BeanType>(candidates.size());
            block0: for (BeanType candidate : candidates) {
                String[] applicableTypes = candidate.getAnnotationMetadata().stringValues(this.annotationType);
                if (applicableTypes.length == 0) {
                    all.add(candidate);
                    continue;
                }
                for (String mt : applicableTypes) {
                    io.micronaut.http.MediaType mediaType = new io.micronaut.http.MediaType(mt);
                    for (io.micronaut.http.MediaType m : this.mediaTypes) {
                        if (!m.matches(mediaType)) continue;
                        all.add(candidate);
                        continue block0;
                    }
                }
            }
            all.sort(Comparator.comparingInt(this::findOrder).reversed());
            return all;
        }

        private int findOrder(BeanType<?> beanType) {
            int order = 0;
            String[] applicableTypes = beanType.getAnnotationMetadata().stringValues(this.annotationType);
            int size = this.mediaTypes.size();
            for (String mt : applicableTypes) {
                int index = this.mediaTypes.indexOf(new io.micronaut.http.MediaType(mt));
                if (index == -1) continue;
                int compareValue = size - index;
                order = Integer.max(order, compareValue);
            }
            return order;
        }

        private static boolean isInvalidType(List<Argument<?>> consumedType, Argument<?> requiredType) {
            Argument<?> argument = consumedType.get(0);
            return !argument.isTypeVariable() && !argument.isAssignableFrom(requiredType.getType());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MediaTypeQualifier that = (MediaTypeQualifier)((Object)o);
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        public int hashCode() {
            return Objects.hash(this.type.typeHashCode(), this.mediaTypes);
        }

        public String toString() {
            return "MediaTypeQualifier[type=" + this.type + ", mediaTypes=" + this.mediaTypes + ", annotationType=" + this.annotationType + "]";
        }
    }

    private record HandlerKey<T>(Argument<T> type, List<io.micronaut.http.MediaType> mediaTypes) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerKey that = (HandlerKey)o;
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash((Object)this.type.typeHashCode(), this.mediaTypes);
        }
    }

    private static final class NoReader
    implements io.micronaut.http.body.MessageBodyReader<Object> {
        private NoReader() {
        }

        @Nullable
        public Object read(@NonNull Argument<Object> type, @Nullable io.micronaut.http.MediaType mediaType, @NonNull Headers httpHeaders, @NonNull InputStream inputStream) throws CodecException {
            return null;
        }
    }

    private static final class NoWriter
    implements io.micronaut.http.body.MessageBodyWriter<Object> {
        private NoWriter() {
        }

        public void writeTo(@NonNull Argument<Object> type, @NonNull io.micronaut.http.MediaType mediaType, Object object, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        }
    }
}

