/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsIOException;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;

@Internal
public final class JaxRsMessageBodyReader<T>
implements MessageBodyReader<T> {
    private final jakarta.ws.rs.ext.MessageBodyReader<T> delegate;

    public JaxRsMessageBodyReader(jakarta.ws.rs.ext.MessageBodyReader<T> delegate) {
        this.delegate = delegate;
    }

    public boolean isReadable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return this.delegate.isReadable(type.getType(), type.asType(), type.getAnnotationMetadata().synthesizeAll(), JaxRsUtils.convert(mediaType));
    }

    @Nullable
    public T read(@NonNull Argument<T> type, @Nullable MediaType mediaType, @NonNull Headers httpHeaders, @NonNull InputStream inputStream) throws CodecException {
        try {
            return (T)this.delegate.readFrom(type.getType(), type.asType(), type.getAnnotationMetadata().synthesizeAll(), JaxRsUtils.convert(mediaType), (MultivaluedMap)new JaxRsHeadersMultivaluedMap(httpHeaders), inputStream);
        }
        catch (IOException e) {
            throw new JaxRsIOException("Failed to read", e);
        }
    }
}

