/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.jaxrs.common.AbstractJaxRsInterceptorContext;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

@Internal
public final class JaxRsReaderInterceptorContext
extends AbstractJaxRsInterceptorContext
implements ReaderInterceptorContext {
    private final Iterator<ReaderInterceptor> interceptors;
    private final IOProceedSupplier<Object> interceptedSupplier;
    private final MultivaluedMap<String, String> headers;
    private InputStream inputStream;

    public JaxRsReaderInterceptorContext(Iterator<ReaderInterceptor> interceptors, IOProceedSupplier<Object> interceptedSupplier, Argument<?> argument, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream inputStream) {
        super(argument, mediaType);
        this.interceptors = interceptors;
        this.interceptedSupplier = interceptedSupplier;
        this.headers = headers;
        this.inputStream = inputStream;
    }

    public Object proceed() throws IOException, WebApplicationException {
        if (this.interceptors.hasNext()) {
            return this.interceptors.next().aroundReadFrom((ReaderInterceptorContext)this);
        }
        return this.interceptedSupplier.get(this);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    @FunctionalInterface
    public static interface IOProceedSupplier<T> {
        public T get(JaxRsReaderInterceptorContext var1) throws IOException;
    }
}

