/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.jaxrs.common.JaxRsGenericEntity;
import io.micronaut.jaxrs.common.JaxRsMutableResponse;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;

@Internal
final class JaxRsResponseBuilder
extends Response.ResponseBuilder {
    private final MutableHttpResponse<Object> response;

    JaxRsResponseBuilder() {
        this((MutableHttpResponse<Object>)HttpResponse.ok());
    }

    JaxRsResponseBuilder(MutableHttpResponse<Object> response) {
        this.response = response;
    }

    public Response build() {
        MutableHttpResponse mutableHttpResponse = HttpResponse.status((int)this.response.code(), (String)this.response.reason()).body(this.response.getBody().orElse(null)).headers(newHeaders -> this.response.getHeaders().forEachValue((arg_0, arg_1) -> ((MutableHttpHeaders)newHeaders).add(arg_0, arg_1)));
        return new JaxRsMutableResponse(mutableHttpResponse);
    }

    public Response.ResponseBuilder clone() {
        return new JaxRsResponseBuilder();
    }

    public Response.ResponseBuilder status(int status) {
        this.response.status(status);
        return this;
    }

    public Response.ResponseBuilder status(int status, String reasonPhrase) {
        this.response.status(status, (CharSequence)reasonPhrase);
        return this;
    }

    public Response.ResponseBuilder entity(Object entity) {
        this.response.body(entity);
        if (entity == null && this.response.getStatus() == HttpStatus.OK) {
            this.response.status(Response.Status.NO_CONTENT.getStatusCode());
        }
        return this;
    }

    public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
        this.entity(new JaxRsGenericEntity<Object>(entity, annotations));
        return this;
    }

    public Response.ResponseBuilder allow(String ... methods) {
        if (methods == null) {
            this.response.getHeaders().remove((CharSequence)"Allow");
        } else {
            this.response.getHeaders().allowGeneric(Arrays.asList(methods));
        }
        return this;
    }

    public Response.ResponseBuilder allow(Set<String> methods) {
        if (methods == null) {
            this.response.getHeaders().remove((CharSequence)"Allow");
        } else {
            this.response.getHeaders().allowGeneric(methods);
        }
        return this;
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        this.header("Cache-Control", cacheControl);
        return this;
    }

    public Response.ResponseBuilder encoding(String encoding) {
        this.header("Content-Encoding", encoding);
        return this;
    }

    public Response.ResponseBuilder header(String name, Object value) {
        if (value != null) {
            if (value instanceof Date) {
                Date date = (Date)value;
                this.response.getHeaders().add((CharSequence)name, ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
            } else {
                RuntimeDelegate.HeaderDelegate headerDelegate = RuntimeDelegate.getInstance().createHeaderDelegate(value.getClass());
                if (headerDelegate == null) {
                    this.response.header((CharSequence)name, (CharSequence)value.toString());
                } else {
                    String stringValue = headerDelegate.toString(value);
                    this.response.header((CharSequence)name, (CharSequence)(stringValue == null ? "" : stringValue));
                }
            }
        } else {
            this.response.getHeaders().remove((CharSequence)name);
        }
        return this;
    }

    public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
        for (String k : List.copyOf(this.response.getHeaders().names())) {
            this.response.getHeaders().remove((CharSequence)k);
        }
        if (headers != null) {
            headers.forEach((s, objects) -> {
                for (Object object : objects) {
                    if (object == null) continue;
                    this.response.getHeaders().add((CharSequence)s, (CharSequence)object.toString());
                }
            });
            return this;
        }
        return this;
    }

    public Response.ResponseBuilder language(String language) {
        this.response.header((CharSequence)"Content-Language", (CharSequence)language);
        return this;
    }

    public Response.ResponseBuilder language(Locale language) {
        this.response.header((CharSequence)"Content-Language", (CharSequence)language.toLanguageTag());
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        if (type == null) {
            this.response.getHeaders().remove((CharSequence)"Content-Type");
        } else {
            this.response.contentType(new io.micronaut.http.MediaType(type.toString()));
        }
        return this;
    }

    public Response.ResponseBuilder type(String type) {
        if (type == null) {
            this.response.getHeaders().remove((CharSequence)"Content-Type");
        } else {
            this.response.contentType((CharSequence)type);
        }
        return this;
    }

    public Response.ResponseBuilder variant(Variant variant) {
        return this;
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        this.header("Content-Location", location);
        return this;
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        if (cookies == null) {
            this.response.getHeaders().remove((CharSequence)"Set-Cookie");
            return this;
        }
        for (NewCookie cookie : cookies) {
            Date expiry;
            String path;
            Cookie c = Cookie.of((String)cookie.getName(), (String)cookie.getValue());
            String domain = cookie.getDomain();
            if (domain != null) {
                c.domain(domain);
            }
            if ((path = cookie.getPath()) != null) {
                c.path(path);
            }
            if ((expiry = cookie.getExpiry()) != null) {
                long maxAge = expiry.getTime() - new Date().getTime();
                if (maxAge < 0L) {
                    throw new IllegalArgumentException("Expiry should not be in the past");
                }
                c.maxAge(maxAge);
            }
            this.response.cookie(c);
        }
        return this;
    }

    public Response.ResponseBuilder expires(Date expires) {
        MutableHttpHeaders headers = this.response.getHeaders();
        if (expires == null) {
            headers.remove((CharSequence)"Expect");
        } else {
            headers.expires(expires.getTime());
        }
        return this;
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        MutableHttpHeaders headers = this.response.getHeaders();
        if (lastModified == null) {
            headers.remove((CharSequence)"Last-Modified");
        } else {
            headers.lastModified(lastModified.getTime());
        }
        return this;
    }

    public Response.ResponseBuilder location(URI location) {
        MutableHttpHeaders headers = this.response.getHeaders();
        if (location == null) {
            headers.remove((CharSequence)"Location");
        } else if (location.isAbsolute()) {
            headers.location(location);
        } else {
            headers.location(location);
        }
        return this;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        if (tag != null) {
            this.response.getHeaders().set((CharSequence)"ETag", (CharSequence)RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).toString((Object)tag));
        }
        return this;
    }

    public Response.ResponseBuilder tag(String tag) {
        if (tag != null) {
            this.response.getHeaders().set((CharSequence)"ETag", (CharSequence)tag);
        }
        return this;
    }

    public Response.ResponseBuilder variants(Variant ... variants) {
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        return this;
    }

    public Response.ResponseBuilder links(Link ... links) {
        MutableHttpHeaders headers = this.response.getHeaders();
        for (Link link : links) {
            headers.add((CharSequence)"Link", (CharSequence)link.toString());
        }
        return this;
    }

    public Response.ResponseBuilder link(URI uri, String rel) {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        ArgumentUtils.requireNonNull((String)"rel", (Object)rel);
        Link link = Link.fromUri((URI)uri).rel(rel).build(new Object[0]);
        this.response.getHeaders().add((CharSequence)"Link", (CharSequence)link.toString());
        return this;
    }

    public Response.ResponseBuilder link(String uri, String rel) {
        return this.link(URI.create(uri), rel);
    }
}

