/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common;

import io.micronaut.core.annotation.Internal;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Internal
class LinkImpl
extends Link {
    private static final RuntimeDelegate.HeaderDelegate<Link> DELEGATE = RuntimeDelegate.getInstance().createHeaderDelegate(Link.class);
    protected final Map<String, String> map;
    private final URI uri;

    LinkImpl(URI uri, Map<String, String> map) {
        this.uri = uri;
        this.map = map.isEmpty() ? Collections.emptyMap() : Map.copyOf(map);
    }

    public static Link valueOf(String value) {
        return (Link)DELEGATE.fromString(value);
    }

    public URI getUri() {
        return this.uri;
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri((URI)this.uri);
    }

    public String getRel() {
        return this.map.get("rel");
    }

    public List<String> getRels() {
        String rels = this.map.get("rel");
        return rels == null ? Collections.emptyList() : Arrays.asList(rels.split(" +"));
    }

    public String getTitle() {
        return this.map.get("title");
    }

    public String getType() {
        return this.map.get("type");
    }

    public Map<String, String> getParams() {
        return this.map;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LinkImpl) {
            LinkImpl otherLink = (LinkImpl)((Object)other);
            return this.uri.equals(otherLink.uri) && this.map.equals(otherLink.map);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 89 * hash + (this.map != null ? this.map.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return DELEGATE.toString((Object)this);
    }
}

