/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common.body.standard;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.jaxrs.common.JaxRsIOException;
import io.micronaut.jaxrs.common.body.standard.JaxRsStringMessageBodyReaderWriter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Order(value=0x7FFFFFFF)
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Prototype
@Internal
final class JaxRsCharacterMessageBodyReaderWriter
implements MessageBodyReader<Character>,
MessageBodyWriter<Character> {
    JaxRsCharacterMessageBodyReaderWriter() {
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == Character.class && MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(type, genericType, annotations, mediaType);
    }

    public Character readFrom(Class<Character> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return Character.valueOf(JaxRsStringMessageBodyReaderWriter.readToString(entityStream, mediaType, true).charAt(0));
    }

    public void writeTo(Character character, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            entityStream.write(character.charValue());
        }
        catch (IOException e) {
            throw new JaxRsIOException(e);
        }
    }
}

