/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common.body.standard;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.jaxrs.common.JaxRsIOException;
import io.micronaut.jaxrs.common.body.standard.QueryStringEncoder;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

@Order(value=0x7FFFFFFF)
@Produces(value={"application/x-www-form-urlencoded"})
@Internal
@Prototype
public final class JaxRsMultivaluedMapMessageBodyWriter
implements MessageBodyWriter<MultivaluedMap<String, String>> {
    public boolean isWriteable(@NonNull Argument<MultivaluedMap<String, String>> type, @Nullable MediaType mediaType) {
        return super.isWriteable(type, mediaType) && MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)mediaType);
    }

    @NonNull
    public ByteBuffer<?> writeTo(@NonNull Argument<MultivaluedMap<String, String>> type, @NonNull MediaType mediaType, MultivaluedMap<String, String> object, @NonNull MutableHeaders outgoingHeaders, @NonNull ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        return super.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
    }

    public void writeTo(@NonNull Argument<MultivaluedMap<String, String>> type, @NonNull MediaType mediaType, MultivaluedMap<String, String> object, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        outgoingHeaders.setIfMissing((CharSequence)"Content-Type", (CharSequence)"application/x-www-form-urlencoded");
        try {
            QueryStringEncoder encoder = new QueryStringEncoder("", StandardCharsets.UTF_8);
            for (Map.Entry e : object.entrySet()) {
                ((List)e.getValue()).forEach(value -> encoder.addParam((String)e.getKey(), (String)value));
            }
            outputStream.write(encoder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new JaxRsIOException(e);
        }
    }
}

