/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.common.body.standard;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Headers;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

@Order(value=0x7FFFFFFF)
@Prototype
@Internal
public final class JaxRsReaderMessageBodyReader
implements MessageBodyReader<Reader> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Reader.class.isAssignableFrom(type);
    }

    public Reader readFrom(Class<Reader> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        Optional charset = MessageBodyWriter.findCharset((io.micronaut.http.MediaType)JaxRsUtils.convert(mediaType), (Headers)new CaseInsensitiveMutableHttpHeaders(httpHeaders, ConversionService.SHARED));
        return new InputStreamReader(entityStream, charset.orElse(StandardCharsets.UTF_8));
    }
}

