/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.processor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.CustomHttpMethod;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.Trace;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@Internal
public class HttpMethodMapper
implements NamedAnnotationMapper {
    @NonNull
    public String getName() {
        return "javax.ws.rs.HttpMethod";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        String name = annotation.stringValue().orElse(null);
        if (name != null) {
            name = name.toUpperCase(Locale.ENGLISH);
            HttpMethod httpMethod = HttpMethod.parse((String)name);
            AnnotationValueBuilder builder = null;
            switch (httpMethod) {
                case GET: {
                    builder = AnnotationValue.builder(Get.class);
                    break;
                }
                case POST: {
                    builder = AnnotationValue.builder(Post.class);
                    break;
                }
                case PUT: {
                    builder = AnnotationValue.builder(Put.class);
                    break;
                }
                case PATCH: {
                    builder = AnnotationValue.builder(Patch.class);
                    break;
                }
                case DELETE: {
                    builder = AnnotationValue.builder(Delete.class);
                    break;
                }
                case TRACE: {
                    builder = AnnotationValue.builder(Trace.class);
                    break;
                }
                case OPTIONS: {
                    builder = AnnotationValue.builder(Options.class);
                    break;
                }
                case HEAD: {
                    builder = AnnotationValue.builder(Head.class);
                    break;
                }
                default: {
                    builder = AnnotationValue.builder(CustomHttpMethod.class);
                    builder.member("method", name);
                }
            }
            return Collections.singletonList(builder.value("/").build());
        }
        return Collections.emptyList();
    }
}

